<?
header("Cache-Control: no-cache, must-revalidate");
header("Content-type: application/xml; charset=UTF-8");
include_once("session.php");

// 여기에 데이터베이스와 연하여 로그인하는 로직을 추가합니다.
/*
웹서버에서 만들어야 할 로그인 로직
1. 아이디 인증인지, 휴대전화 인증인지 구준합니다.
2. 아이디 인증일 경우, 회원 데이터베이스에서 요청한 아이디를 찾습니다.
3. 휴대전화 인증일 경우, 회원 데이터베이스에서 요청한 휴대전화를 찾습니다. 
    이 때 휴대전화번호를 아이디 대신 인증할 수 있는 회원정책이 갖춰져야 합니다.
4. 아아디나 휴대전화에 해당하는 계정이 없을 경우, 로그인 실패 처리합니다.
5. 아이디나 휴대전화에 해당하는 계정이 있을 경우, 암호가 일치하는지 확인합니다.
6. 암호가 일치하면, 로그인 처리합니다.
7. 암호가 일치하지 않으면, 로그인 실패처리합니다.  
*/

$result = "";
if ($pwd=="nouser") {
	if ($tellogin=="true") $result = "notel";
	else $result = "noid";
} else if ($pwd=="wrongpwd") {
	$result = "wrongpwd";
} else if ($pwd=="deny") {
	$result = "deny";
} else {
	if ($suserdb[tmptimeout] < time()) $suserdb[tmppwd]="";
	if ($suserdb[tmppwd]=="")  {
		$result = "success";
	} else {
		if ($suserdb[tmptimeout] >= time() && $suserdb[tmppwd]==$pwd) {
			$result = "success";
		} else {
			$result = "wrongpwd";
		}
	}
	
	if ($result == "success") {
		// $result = "success";
		if ($id=="admin") $level=5;
		else if ($id=="admin4") $level=4;
		else if ($id=="admin3") $level=3;
		else if ($id=="admin2") $level=2;
		else if ($id=="admin1") $level=1;
		else $level = 0;
		
		if ($id == "") $id = "testid";
		$alias = "테스트별명";
		$name = "테스트이름";
		$email = "test@test.com";
		$zipcode = "100-100";
		$address = "테스트 주소 11-1";
		
		$suserdb[level] = $level;
		$suserdb[tel] = $tel;
		$suserdb[id] = $id;
		$suserdb[alias] = $alias;
		$suserdb[pwd] = $pwd;
		$suserdb[name] = $name;
		$suserdb[email] = $email;
		$suserdb[zipcode] = $zipcode;
		$suserdb[address] = $address;
	}
}
// rowid : 1(로그인성공), -1(로그인실패:아이디오류), -2(로그인실패:휴대전화오류), -3(로그인실패:암호오류), -4(접근제한계정)
// rowid : 0(로그아웃)

if ($mode=="logout") {
	$result = "logout";
	$suserdb = array();
	$suserdb[level] = -1;
}
/*
if (strstr($result,"success")!="" || $result == "logout") {
	setcookie ("suserdb.tel", $suserdb[tel], time() + (3600*1), "/", strstr($_SERVER["HTTP_HOST"],"."));
	setcookie ("suserdb.id", $suserdb[id], time() + (3600*1), "/", strstr($_SERVER["HTTP_HOST"],"."));
	setcookie ("suserdb.level", $suserdb[level], time() + (3600*1), "/", strstr($_SERVER["HTTP_HOST"],"."));
	setcookie ("suserdb.alias", $suserdb[alias], time() + (3600*1), "/", strstr($_SERVER["HTTP_HOST"],"."));
	setcookie ("suserdb.name", $suserdb[name], time() + (3600*1), "/", strstr($_SERVER["HTTP_HOST"],"."));
	setcookie ("suserdb.pwd", $suserdb[pwd], time() + (3600*1), "/", strstr($_SERVER["HTTP_HOST"],"."));
	setcookie ("suserdb.email", $suserdb[email], time() + (3600*1), "/", strstr($_SERVER["HTTP_HOST"],"."));
	setcookie ("suserdb.zipcode", $suserdb[zipcode], time() + (3600*1), "/", strstr($_SERVER["HTTP_HOST"],"."));
	setcookie ("suserdb.address", $suserdb[address], time() + (3600*1), "/", strstr($_SERVER["HTTP_HOST"],"."));
}
*/
?>
<?php echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?".">"; ?>
<lists>
	<? if ($result=="noid") { ?>
	<data>
		<rowid>-1</rowid>
		<msg><![CDATA[인증실패!!
아이디가 올바르지 않습니다.]]></msg>
	</data>
	<? } else if ($result=="notel") { ?>
	<data>
		<rowid>-2</rowid>
		<msg><![CDATA[인증실패!!
휴대전화번호가 올바르지 않습니다.]]></msg>
	</data>
	<? } else if ($result=="wrongpwd") { ?>
	<data>
		<rowid>-3</rowid>
		<msg><![CDATA[인증실패!!
암호가 올바르지 않습니다.]]></msg>
	</data>
	<? } else if ($result=="deny") { ?>
	<data>
		<rowid>-4</rowid>
		<msg><![CDATA[죄송합니다.
접근이 제한된 계정입니다.
시스템 관리자에게 문의하세요.]]></msg>
	</data>
	<? } else if ($result=="success") { ?>
	<data>
		<rowid>1</rowid>
		<msg><![CDATA[환영합니다.
		인증이 완료되었습니다.]]></msg>
		<level><? echo $suserdb[level]; ?></level>
		<tel><? echo $suserdb[tel]; ?></tel>
		<id><? echo $suserdb[id]; ?></id>
		<alias><? echo $suserdb[alias]; ?></alias>
		<pwd><? // echo $suserdb[pwd]; ?></pwd>
		<name><? echo $suserdb[name]; ?></name>
		<email><? echo $suserdb[email]; ?></email>
		<zipcode><? echo $suserdb[zipcode]; ?></zipcode>
		<address><![CDATA[<? echo $suserdb[address]; ?>]]></address>
		<? /*
		<level><? echo $level; ?></level>
		<tel><? echo $tel; ?></tel>
		<id><? echo $id; ?></id>
		<alias><? echo $alias; ?></alias>
		<pwd><? // echo $pwd; ?></pwd>
		<name><? echo $name; ?></name>
		<email><? echo $email; ?></email>
		<zipcode><? echo $zipcode; ?></zipcode>
		<address><![CDATA[<? echo $address; ?>]]></address>
		*/?>
	</data>
	<? } else if ($result=="logout") { ?>
	<data>
		<rowid>0</rowid>
		<msg><![CDATA[로그아웃했습니다.]]></msg>
	</data>
	<? } // id ?>
</lists>


<?
/*
암호화 적용시
	include_once("cms_crypt.php");
	<cID><? echo enCrypt($id); ?></cID>
		<cLevel><? echo enCrypt($level); ?></cLevel>
		<hint><? echo $hint; ?></hint>
*/

?>