/*
//
//  user.m
//  owlBookStoreNaviWeb
//
//  Created by owl on 11. 1. 19..
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//
*/
#import "user.h"

@implementation user

@synthesize level, groups;
@synthesize position, part;

- (id)init {
	if (self == [super init]) {
		name = @"익명";
		level = -1;
		groups = [[NSArray alloc] init];
	}
	return self;
}

+ (user *)userWithName:(NSString *)newName {
	return [[self alloc] initWithName:newName];	
}

- (id)initWithName:(NSString *)newName {
	if (self == [super init]) {
		name = [newName copy];
		level = -1;
		groups = [[NSArray alloc] init];
	}
	return self;
}

- (int)level {
	return level;	
}

- (void)setLevel:(int)newLevel {
	level = newLevel;
}

- (NSString *)name {
	return name;
}

- (void)setName:(NSString *)newName {
	if (newName != name) {
		[newName retain];
		[name release];
		name = newName;
	}
}

- (NSArray *)groups {
	return groups;
}

- (void)setGroups:(NSArray *)newGroups {
	if (groups != newGroups) {
		[groups release];
		groups = [newGroups mutableCopy];
	}
}

- (NSString *)getGroup {
	return part;
}

- (void)setGroup:(NSString *)newGroup {
	[self setPart:newGroup];
}

-(void)dealloc {
	[name release];
	[groups release];
	[position release];
	[part release];
	[super dealloc];
}

- (void) testAutoreleaseDrain:(NSArray *)args {
    /*
	 이 샘플코드는 autorelease와 drain에 관한 사례입니다.
	 */
	
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
    for (NSString *tmpName in args) {
        NSAutoreleasePool *loopPool = [[NSAutoreleasePool alloc] init];
        NSError *error = nil;
        NSString *tmpContents = [[[NSString alloc] 
								   initWithContentsOfFile:tmpName
								   encoding:NSUTF8StringEncoding 
								   error:&error] autorelease];
        /* 
		 반복하는 동안 autorelease 메시지를 전달한 객체들을 모두 
		 loopPool에 기록해 두었다가 drain 명령으로 
		 loopPool에 담은 객체들을 메모리에서 삭제합니다.
		 */
        [loopPool drain];
    }
    /* 
	 pool에 기록해 둔 모튼 객체를 drain 메시지로 모두 메모리에서 삭제합니다.
	 */
    [pool drain];
	
}
- (id) testAutoreleaseRetainRelease:(id)anObject {
	/*
	 이 샘플코드는 autorelease, retain, release 특성을 보여주는 샘플입니다.
	 */
	id searchNil = nil;
    while (searchNil == nil) {
        NSAutoreleasePool *autuPool = [[NSAutoreleasePool alloc] init];
        searchNil = [self expensiveSearchForObject:anObject];
        if (searchNil != nil) {
			/* retain 메시지로 searchNil 값을 메모리에 보존합니다.*/
            [searchNil retain]; 
        }
		/* 
		 메모리를 통해 찾아왔던 객체를 메모리에서 삭제합니다. 
		 이 때, searchNil는 메모리에 보존되어 있습니다.
		 */
        [autuPool release];
    }
	
	/*
	 autorelease 메세지로 searchNil를 리턴한 후에 메모리에서 삭제합니다.
	 */
    return [searchNil autorelease]; 
}

@end

