
#import "smartView.h"
#import "Report.h"
#import "typeView.h"
#import "photoView.h"

@interface smartView (PrivateMethods)
- (void)updatePhotoButton;
- (void)updateMovieButton;
@end

#pragma mark -
#pragma mark making the SSL Allowed.. 
@interface NSURLRequest (DummyInterface)
+ (BOOL)allowsAnyHTTPSCertificateForHost:(NSString*)host;
+ (void)setAllowsAnyHTTPSCertificate:(BOOL)allow forHost:(NSString*)host;
@end

@implementation smartView

@synthesize report;
@synthesize myInfo;
@synthesize theMoviePlayer;
@synthesize dicParm;
@synthesize uploadType;
@synthesize rawData, dicData;

#pragma mark -
#pragma mark Section define
#define TYPE_SECTION 0



#pragma mark -
#pragma mark Initialization

/*
 - (id)initWithStyle:(UITableViewStyle)style {
     // Override initWithStyle: if you create the controller programmatically and want to perform customization that is not appropriate for viewDidLoad.
     self = [super initWithStyle:style];
     if (self) {
        // Custom initialization.
     }
     return self;
 }
 */

#pragma mark -
#pragma mark View lifecycle

- (void)viewDidLoad {
    [super viewDidLoad];
    
	myInfo = [[NSMutableDictionary alloc] init];
	[self getCookies];
    
    if ([report.reg_id isEqualToString:[myInfo objectForKey:@"suserdb.userid"]]) {
        self.navigationItem.rightBarButtonItem = self.editButtonItem;
    }
    
    if (tableHeaderView == nil) {
        [[NSBundle mainBundle] loadNibNamed:@"smartViewHeader" owner:self options:nil];
        self.tableView.tableHeaderView = tableHeaderView;
        self.tableView.allowsSelectionDuringEditing = YES;
    }
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
	
	[photoButton setImage:report.listImage forState:UIControlStateNormal];
    [self updatePhotoButton];
    [self updateMovieButton];
    
	self.navigationItem.title = report.type;
    inputSubject.text = report.subject;    
    inputWriter.text = report.writer;   
    inputRegDate.text = [self getDateTime:report.reg_date];
	inputContent.text = report.content;  
    inputRowid.text = [report.rowid stringValue];
    if ([report.publish integerValue] == 1) [publishSwitch setOn:YES];
    else [publishSwitch setOn:NO];
    if ([[self.navigationItem title] length]<=0) self.navigationItem.title = @"Unsorted";
    [self.tableView reloadData]; 
}

- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    return (interfaceOrientation != UIInterfaceOrientationPortraitUpsideDown);
}

#pragma mark - Memory Management

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}

- (void)dealloc {
    [inputSubject release];
    [inputWriter release];
    [inputRegDate release];
    [inputRowid release];
    [photoButton release];
    [movieButton release];
    [publishSwitch release];
    [inputContent release];
    [tableHeaderView release];
    [theMoviePlayer release];

    [report release];
	[myInfo release];
    
    [dicParm release];
	[rawData release];
	[dicData release];
    
    [super dealloc];
}

- (void)viewDidUnload {
    [inputSubject release];
    inputSubject = nil;
    [inputWriter release];
    inputWriter = nil;
    [inputRegDate release];
    inputRegDate = nil;
    [inputRowid release];
    inputRowid = nil;
    [photoButton release];
    photoButton = nil;
    [movieButton release];
    movieButton = nil;
    [publishSwitch release];
    publishSwitch = nil;
    [inputContent release];
    inputContent = nil;
    [tableHeaderView release];
    tableHeaderView = nil;
    [super viewDidUnload];
    // Release any retained subviews of the main view.
    // e.g. self.myOutlet = nil;
}


#pragma mark - Table view data source

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 2;
}

- (NSString *)tableView:(UITableView *)tableView titleForHeaderInSection:(NSInteger)section {
    NSString *title = nil;
    switch (section) {
        case TYPE_SECTION:
            title = @"Category";
            break;
        default:
            break;
    }
    return title;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    NSInteger rows = 0;
    switch (section) {
        case TYPE_SECTION:
            rows = 1;
            break;
		default:
            break;
    }
    return rows;
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    UITableViewCell *cell = nil;
	static NSString *CellIdentifier = @"CellIdentifier";	
    cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil) {
        cell = [[[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:CellIdentifier] autorelease];
        cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
    }
    NSString *text = nil;
    switch (indexPath.section) {
        case TYPE_SECTION:
            text = report.type;
            cell.accessoryType = UITableViewCellAccessoryNone;
            cell.editingAccessoryType = UITableViewCellAccessoryDisclosureIndicator;
            break;
        default:
            break;
    }
    cell.textLabel.text = text;
    return cell;
}


/*
// Override to support conditional editing of the table view.
- (BOOL)tableView:(UITableView *)tableView canEditRowAtIndexPath:(NSIndexPath *)indexPath
{
    // Return NO if you do not want the specified item to be editable.
    return YES;
}
*/

/*
// Override to support editing the table view.
- (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (editingStyle == UITableViewCellEditingStyleDelete) {
        // Delete the row from the data source
        [tableView deleteRowsAtIndexPaths:[NSArray arrayWithObject:indexPath] withRowAnimation:UITableViewRowAnimationFade];
    }   
    else if (editingStyle == UITableViewCellEditingStyleInsert) {
        // Create a new instance of the appropriate class, insert it into the array, and add a new row to the table view
    }   
}
*/

/*
// Override to support rearranging the table view.
- (void)tableView:(UITableView *)tableView moveRowAtIndexPath:(NSIndexPath *)fromIndexPath toIndexPath:(NSIndexPath *)toIndexPath
{
}
*/

/*
// Override to support conditional rearranging of the table view.
- (BOOL)tableView:(UITableView *)tableView canMoveRowAtIndexPath:(NSIndexPath *)indexPath
{
    // Return NO if you do not want the item to be re-orderable.
    return YES;
}
*/

#pragma mark - Table view delegate

- (NSIndexPath *)tableView:(UITableView *)tableView willSelectRowAtIndexPath:(NSIndexPath *)indexPath {
	NSIndexPath *rowToSelect = indexPath;
    NSInteger section = indexPath.section;
    BOOL isEditing = self.editing;
    if (isEditing && section == TYPE_SECTION) { } else  {
        [tableView deselectRowAtIndexPath:indexPath animated:YES];
        rowToSelect = nil;    
    }
	return rowToSelect;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    
    NSInteger section = indexPath.section;
    UIViewController *nextViewController = nil;
	
    switch (section) {
        case TYPE_SECTION:
            nextViewController = [[typeView alloc] initWithStyle:UITableViewStyleGrouped];
            ((typeView *)nextViewController).report = report;
            break;
        default:
            break;
    }
    
    if (nextViewController) {
        [self.navigationController pushViewController:nextViewController animated:YES];
        [nextViewController release];
    }
}


- (UITableViewCellEditingStyle)tableView:(UITableView *)tableView editingStyleForRowAtIndexPath:(NSIndexPath *)indexPath {
	UITableViewCellEditingStyle style = UITableViewCellEditingStyleNone;
    
    return style;
}


- (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath {
    
}

#pragma mark - Editing

- (void)setEditing:(BOOL)editing animated:(BOOL)animated {
    
    [super setEditing:editing animated:animated];
    
	[self updatePhotoButton];
    [self updateMovieButton];
    
	inputSubject.enabled = editing;
	inputWriter.enabled = NO;
	inputRegDate.enabled = NO;
	inputContent.editable = editing;
    publishSwitch.enabled = editing;
	[self.navigationItem setHidesBackButton:editing animated:YES];
	
	if (!editing) {
		report.local_state = @"[Modified] ";
        NSManagedObjectContext *context = report.managedObjectContext;
		NSError *error = nil;
		if (![context save:&error]) {
			NSLog(@"Unresolved error %@, %@", error, [error userInfo]);
			abort();
		}

        [self uploadData];
         
    }
}


#pragma mark - UITextView UITextField Delegate

- (void)textViewDidEndEditing:(UITextView *)textView {
	if (textView == inputContent) {
		report.content = inputContent.text;
	}
}

- (BOOL)textFieldShouldEndEditing:(UITextField *)textField {
	if (textField == inputSubject) {
		report.subject = inputSubject.text;
	}
	return YES;
}


- (BOOL)textFieldShouldReturn:(UITextField *)textField {
	[textField resignFirstResponder];
	return YES;
}


#pragma mark -
#pragma mark NSHTTPCookieStorage Utils

- (void) getCookies {
	[myInfo removeAllObjects];
	NSArray *cookiea = [[NSHTTPCookieStorage sharedHTTPCookieStorage] cookies];
	for (int c=0; c<[cookiea count]; c++) {
		[myInfo setObject:[[cookiea objectAtIndex:c] value] forKey:[[cookiea objectAtIndex:c] name]];
		NSLog(@"%s [%d]: %@: %@", __PRETTY_FUNCTION__, __LINE__, [[cookiea objectAtIndex:c] name], [[cookiea objectAtIndex:c] value]);
	}
}

- (NSString *) getDateTime:(NSDate *) theDate {
	NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
	[dateFormatter setDateFormat:@"yyyy-MM-dd HH:mm:ss"];
	NSString *strDate = [dateFormatter stringFromDate:theDate];
	[dateFormatter release];
	return strDate;
}


#pragma mark - Photo

- (IBAction)selectPhoto:(id)sender {
    if (self.editing) {
		UIImagePickerController *imagePicker = [[UIImagePickerController alloc] init];
        imagePicker.sourceType = UIImagePickerControllerSourceTypePhotoLibrary;
		imagePicker.delegate = self;
        imagePicker.allowsEditing = YES;
		[self presentModalViewController:imagePicker animated:YES];
		[imagePicker release];
	} else {
        if (report.listImage!=nil && report.cryptid!=nil
            && [report.image valueForKey:@"image"]==nil) {
            [report.image setValue:[UIImage imageWithData:[NSData dataWithContentsOfURL:[NSURL URLWithString:[NSString stringWithFormat:@"http://www.owllab.com/ios/smartreport_file.php?imageid=%@",report.cryptid]]]] forKey:@"image"];
            NSManagedObjectContext *context = report.managedObjectContext;
            NSError *error = nil;
            if (![context save:&error]) {
                NSLog(@"Unresolved error %@, %@", error, [error userInfo]);
                abort();
            }           
        }
        
        photoView *photoViewTmp = [[photoView alloc] initWithNibName:@"photoView" bundle:nil];
        photoViewTmp.hidesBottomBarWhenPushed = YES;
        photoViewTmp.title = report.subject;
		photoViewTmp.report = report;
		[self.navigationController pushViewController:photoViewTmp animated:YES];
		[photoViewTmp release];
	}
}

- (void) updatePhotoButton {
	BOOL editing = self.editing;
	if (report.listImage != nil) {
		photoButton.highlighted = editing;
	} else {
		photoButton.enabled = editing;
		if (editing) {
			[photoButton setImage:[UIImage imageNamed:@"photo.png"] forState:UIControlStateNormal];
		} else {
			[photoButton setImage:nil forState:UIControlStateNormal];
		}
	}
}


#pragma mark -
#pragma mark UIImagePickerControllerDelegate Protocol

- (void) imagePickerController:(UIImagePickerController *)picker didFinishPickingMediaWithInfo:(NSDictionary *)info {
    NSLog(@"%s [%d]: start..............", __PRETTY_FUNCTION__, __LINE__);
    NSString* mediaType = [info objectForKey:UIImagePickerControllerMediaType];  
    if ( [mediaType isEqualToString:@"public.image" ]) {    
        UIImage* selectedImage = [info objectForKey:UIImagePickerControllerEditedImage];
        NSManagedObject *oldImage = report.image;
        if (oldImage != nil) {
            [report.managedObjectContext deleteObject:oldImage];
        }
        NSManagedObject *image = [NSEntityDescription insertNewObjectForEntityForName:@"Image" inManagedObjectContext:report.managedObjectContext];
        report.image = image;
        [image setValue:selectedImage forKey:@"image"];
        CGSize size = selectedImage.size;
        CGFloat ratio = 0;
        if (size.width > size.height) ratio = 64.0 / size.width;
        else ratio = 64.0 / size.height;
        CGRect rect = CGRectMake(0.0, 0.0, ratio * size.width, ratio * size.height);
        UIGraphicsBeginImageContext(rect.size);
        [selectedImage drawInRect:rect];
        report.listImage = UIGraphicsGetImageFromCurrentImageContext();
        UIGraphicsEndImageContext();
        [self updatePhotoButton];
    } 
    else if ( [ mediaType isEqualToString:@"public.movie" ]){
        NSURL *videoURL =  [info objectForKey:UIImagePickerControllerMediaURL];
        NSLog(@"%s [%d]: videoURL: %@", __PRETTY_FUNCTION__, __LINE__, videoURL);
        report.movie = [NSString stringWithFormat:@"%@", videoURL];
        [self saveMovieFile:videoURL fileName:[NSString stringWithFormat:@"%@", report.rowid]];
    }
    //    [mediaType release];
    [self dismissModalViewControllerAnimated:YES];
    NSLog(@"%s [%d]: end..............", __PRETTY_FUNCTION__, __LINE__);
}

//– imagePickerController:didFinishPickingImage:editingInfo: Deprecated in iOS 3.0
/*
 - (void)imagePickerController:(UIImagePickerController *)picker didFinishPickingImage:(UIImage *)selectedImage editingInfo:(NSDictionary *)editingInfo {
 
 NSManagedObject *oldImage = report.image;
 if (oldImage != nil) {
 [report.managedObjectContext deleteObject:oldImage];
 }
 
 NSManagedObject *image = [NSEntityDescription insertNewObjectForEntityForName:@"Image" inManagedObjectContext:report.managedObjectContext];
 report.image = image;
 
 [image setValue:selectedImage forKey:@"image"];
 
 CGSize size = selectedImage.size;
 CGFloat ratio = 0;
 if (size.width > size.height) {
 ratio = 44.0 / size.width;
 } else {
 ratio = 44.0 / size.height;
 }
 CGRect rect = CGRectMake(0.0, 0.0, ratio * size.width, ratio * size.height);
 
 UIGraphicsBeginImageContext(rect.size);
 [selectedImage drawInRect:rect];
 report.listImage = UIGraphicsGetImageFromCurrentImageContext();
 UIGraphicsEndImageContext();
 
 [self dismissModalViewControllerAnimated:YES];
 }
 */

- (void)imagePickerControllerDidCancel:(UIImagePickerController *)picker {
    [self dismissModalViewControllerAnimated:YES];
}


#pragma mark - Movie

- (IBAction)selectMovie:(id)sender {
    NSLog(@"%s [%d]: start..............", __PRETTY_FUNCTION__, __LINE__);
    if (self.editing) {
        UIImagePickerController *imagePicker = [[UIImagePickerController alloc] init];
        NSArray *mediaTypesAllowed = [UIImagePickerController availableMediaTypesForSourceType:UIImagePickerControllerSourceTypePhotoLibrary];
        [imagePicker setMediaTypes:mediaTypesAllowed];
        imagePicker.allowsEditing = YES;
        imagePicker.wantsFullScreenLayout = YES;
        imagePicker.delegate = self;
        [self presentModalViewController:imagePicker animated:YES];
        [imagePicker release];
	} else {
        NSLog(@"%s [%d]: report.movie : %@", __PRETTY_FUNCTION__, __LINE__, report.movie);
        if (report.movie!=nil) {
            [self playMovieAtURL:[NSURL URLWithString:report.movie]];
        }
	}
}

- (void) updateMovieButton {
	BOOL editing = self.editing;
	if (report.movie != nil) {
		movieButton.highlighted = editing;
        movieButton.alpha = 1.0;
        [movieButton setImage:[self makeThumbnail:[NSURL URLWithString:report.movie]] forState:UIControlStateNormal];
	} else {
        movieButton.enabled = editing;
		if (editing) {
			[movieButton setImage:[UIImage imageNamed:@"film.png"] forState:UIControlStateNormal];
            movieButton.alpha = 1.0;
		} else {
			[movieButton setImage:nil forState:UIControlStateNormal];
            movieButton.alpha = 0.0;
		}
	}
}

- (UIImage *) makeThumbnail:(NSURL *) theURL {
    MPMoviePlayerController *moviePlayer = [[MPMoviePlayerController alloc] initWithContentURL:theURL];
    moviePlayer.shouldAutoplay = NO;
    UIImage *thumbnail = [[moviePlayer thumbnailImageAtTime:0.0 timeOption:MPMovieTimeOptionNearestKeyFrame] retain];
    return thumbnail;
}


#pragma mark - Saving Movie

- (void) saveMovieFile:(NSURL *) theURL fileName:(NSString *) filename {
    NSData *movieData = [NSData dataWithContentsOfURL:theURL];
    if ([movieData length]>0) {
        NSString *moviePath = [NSString stringWithFormat:@"%@/%@.mov", NSTemporaryDirectory(), filename];
        [movieData writeToFile:moviePath atomically:NO];
        UISaveVideoAtPathToSavedPhotosAlbum (moviePath, self, @selector(movie:didFinishSavingWithError: contextInfo:), nil);
    }
}

- (void) movie:(NSString *) moviePath didFinishSavingWithError:(NSError *) error contextInfo:(void *) contextInfo {
    if (error==nil) {
//        report.movie = [NSString stringWithFormat:@"%@", moviePath];
        [self updateMovieButton];
        NSLog(@"%s [%d] Saved: %@",__PRETTY_FUNCTION__, __LINE__, moviePath);
    } else {
        NSLog(@"%s [%d] Saving Error: %@",__PRETTY_FUNCTION__, __LINE__, error);
    }
}


#pragma mark -
#pragma mark MPMoviePlayerController Utils

- (void) playMovieAtURL:(NSURL*)theURL {
    theMoviePlayer = [[MPMoviePlayerViewController alloc] initWithContentURL:theURL];
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(movieFinishedCallback:) name:MPMoviePlayerPlaybackDidFinishNotification object:theMoviePlayer];
    [self presentMoviePlayerViewControllerAnimated:theMoviePlayer];
    //    self.theMoviePlayer.moviePlayer.movieSourceType = MPMovieSourceTypeFile;
    [self.theMoviePlayer.moviePlayer play];
}

- (void) movieFinishedCallback:(NSNotification*)aNotification {
    [[NSNotificationCenter defaultCenter] removeObserver:self name:MPMoviePlayerPlaybackDidFinishNotification object:theMoviePlayer.moviePlayer];
    [theMoviePlayer release], theMoviePlayer = nil;
}

- (NSURL *) localMovieURL {
    NSURL *movieURL;
    NSString *moviePath = [[NSBundle mainBundle] pathForResource:@"showcase" ofType:@"m4v"];
    if (moviePath) {
        movieURL = [NSURL fileURLWithPath:moviePath];
    }   
    return movieURL;
}


#pragma mark - UIVideoEditorController and Delegate for Exam.

- (void) editMovie:(NSString *) thePath {
    if ([UIVideoEditorController canEditVideoAtPath:thePath]) {    
        UIVideoEditorController *vec = [[UIVideoEditorController alloc] init];
        vec.videoPath = [NSString stringWithFormat:@"%@", thePath];
        vec.delegate = self;
        [self presentModalViewController:vec animated:YES];  
    }
}

- (void)videoEditorController:(UIVideoEditorController *)editor didSaveEditedVideoToPath:(NSString *)editedVideoPath {
    [self saveMovieFile:[NSURL URLWithString: editedVideoPath] fileName:[self getDateTimeName:[NSDate date]]];
    [self dismissModalViewControllerAnimated:YES];
    [editor release];
}

- (void)videoEditorControllerDidCancel:(UIVideoEditorController *)editor {
    [self dismissModalViewControllerAnimated:YES];
    [editor release];
}

- (void)videoEditorController:(UIVideoEditorController *)editor didFailWithError:(NSError *)error {
    [self dismissModalViewControllerAnimated:YES];
    [editor release];
}

- (NSString *) getDateTimeName:(NSDate *) theDate {
    NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
    [dateFormatter setDateFormat:@"yyyyMMddHHmmss"];
    NSString *strDate = [dateFormatter stringFromDate:theDate];
    [dateFormatter release];
    return strDate;
}


#pragma mark - Camera for Exam.

-(IBAction)showPickerCamera {
	if ([UIImagePickerController isSourceTypeAvailable:UIImagePickerControllerSourceTypeCamera]) {
        UIImagePickerController *picker = [[UIImagePickerController alloc] init];
        picker.sourceType = UIImagePickerControllerSourceTypeCamera;
        picker.allowsEditing = NO;
        picker.delegate = self;
        [self presentModalViewController:picker animated:YES];
        [picker release];
    } else {
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:nil message:@"Error" delegate:self cancelButtonTitle:@"Cancel" otherButtonTitles:nil];
        [alert show];
        [alert release];
    }
}


#pragma mark - Switch Publishing

- (IBAction)setPublish:(id)sender {
    if (publishSwitch.on) {
        report.publish = [NSNumber numberWithInt:1];
    } else {
        report.publish = [NSNumber numberWithInt:0];
    }
}


#pragma mark -
#pragma mark Uploading

- (IBAction) uploadData {
    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"Alert: Upload!!" message:@"Anyone can read Published Report only.\nWill you upload this report? " delegate:self cancelButtonTitle:@"Cancel" otherButtonTitles:@"Upload", @"Upload Text Only" , nil];
    [alert show];
    [alert release];
}

- (void) alertView:(UIAlertView *)actionSheet clickedButtonAtIndex:(NSInteger)buttonIndex {
    if (buttonIndex == 0) {
        
    } else if (buttonIndex == 1) {
        uploadType = @"";
        [self putURLData];
    } else {
        uploadType = @"textOnly";
        [self putURLData];
    }
}

#pragma mark -
#pragma mark NSURLConnection

- (void) putURLData {
    NSLog(@"%s [%d]: start...........", __PRETTY_FUNCTION__, __LINE__);
    //     실험주소 :
    //     http://www.owllab.com/ios/smartreport_upload.php
    
    
    [dicData release];
    dicData = [[NSMutableDictionary alloc] init];
    
    NSString *url = @"https://www.owllab.com/ios/smartreport_upload.php";
    
    //making the SSL Allowed.. /////////////////
    NSURL *URL = [NSURL URLWithString:url];
    [NSURLRequest setAllowsAnyHTTPSCertificate:YES forHost:[URL host]];
    //making the SSL Allowed.. /////////////////
    
    NSString * publishTmp = @"0";
    if (publishSwitch.on) publishTmp = @"1";
    if (report.cryptid==nil) report.cryptid = @"";
    if (report.type==nil) report.type = @"";
    
    NSString *boundary = [self makeBoundaryString];
    
    NSMutableURLRequest *urlRequest = [NSMutableURLRequest requestWithURL:[NSURL URLWithString:url] cachePolicy:NSURLRequestUseProtocolCachePolicy timeoutInterval:30.0f];
    
    [urlRequest setHTTPMethod:@"POST"];
    [urlRequest addValue:[NSString stringWithFormat:@"multipart/form-data; boundary=%@",boundary] forHTTPHeaderField: @"Content-Type"];
    [urlRequest addValue:@"8bit" forHTTPHeaderField:@"Content-Transfer-Encoding"];
    
    NSMutableData *body = [NSMutableData data];
    
    [body appendData:[[NSString stringWithFormat:@
                       "\r\n"
                       "--%@\r\n"
                       "Content-Disposition: form-data; name=\"%@\"\r\n\r\n"
                       "%@\r\n"
                       "--%@--\r\n" 
                       "\r\n"
                       , boundary, @"uploadtype", uploadType, boundary] dataUsingEncoding:NSUTF8StringEncoding]];
    
    [body appendData:[[NSString stringWithFormat:@"\r\n--%@\r\nContent-Disposition: form-data; name=\"%@\"\r\n\r\n%@\r\n--%@--\r\n\r\n"
                       , boundary, @"mode", @"sync", boundary] dataUsingEncoding:NSUTF8StringEncoding]];
    
    [body appendData:[[NSString stringWithFormat:@"\r\n--%@\r\nContent-Disposition: form-data; name=\"%@\"\r\n\r\n%@\r\n--%@--\r\n\r\n"
                       , boundary, @"cryptid", report.cryptid, boundary] dataUsingEncoding:NSUTF8StringEncoding]];
    [body appendData:[[NSString stringWithFormat:@"\r\n--%@\r\nContent-Disposition: form-data; name=\"%@\"\r\n\r\n%@\r\n--%@--\r\n\r\n"
                       , boundary, @"subject", report.subject, boundary] dataUsingEncoding:NSUTF8StringEncoding]];
    [body appendData:[[NSString stringWithFormat:@"\r\n--%@\r\nContent-Disposition: form-data; name=\"%@\"\r\n\r\n%@\r\n--%@--\r\n\r\n"
                       , boundary, @"content", report.content, boundary] dataUsingEncoding:NSUTF8StringEncoding]];
    [body appendData:[[NSString stringWithFormat:@"\r\n--%@\r\nContent-Disposition: form-data; name=\"%@\"\r\n\r\n%@\r\n--%@--\r\n\r\n"
                       , boundary, @"publish", publishTmp, boundary] dataUsingEncoding:NSUTF8StringEncoding]];
    [body appendData:[[NSString stringWithFormat:@"\r\n--%@\r\nContent-Disposition: form-data; name=\"%@\"\r\n\r\n%@\r\n--%@--\r\n\r\n"
                       , boundary, @"type", report.type, boundary] dataUsingEncoding:NSUTF8StringEncoding]];
    
    
    
    if ([uploadType isEqualToString:@"textOnly"] == NO) {
        if (report.listImage!=nil) {
            [body appendData:[[NSString stringWithFormat:@"\r\n--%@\r\nContent-Disposition: form-data; name=\"listimage\"; filename=\"%@_list.jpg\"\r\nContent-Type: application/octet-stream\r\n\r\n", boundary,  report.rowid] dataUsingEncoding:NSUTF8StringEncoding]];
            [body appendData:UIImageJPEGRepresentation(report.listImage,1.0)];
            [body appendData:[[NSString stringWithFormat:@"\r\n--%@\r\n", boundary] dataUsingEncoding:NSUTF8StringEncoding]];
            
        }
        if ([report.image valueForKey:@"image"]!=nil) {
            [body appendData:[[NSString stringWithFormat:@"\r\n--%@\r\nContent-Disposition: form-data; name=\"image\"; filename=\"%@.jpg\"\r\nContent-Type: image/jpeg\r\n\r\n", boundary, report.rowid] dataUsingEncoding:NSUTF8StringEncoding]];
            [body appendData:UIImageJPEGRepresentation([report.image valueForKey:@"image"],1.0)];
            [body appendData:[[NSString stringWithFormat:@"\r\n--%@\r\n", boundary] dataUsingEncoding:NSUTF8StringEncoding]];
        }
        if (report.movie!=nil) {
            [body appendData:[[NSString stringWithFormat:@"\r\n--%@\r\nContent-Disposition: form-data; name=\"movie\"; filename=\"%@\"\r\nContent-Type: application/octet-stream\r\n\r\n", boundary, [report.movie lastPathComponent]] dataUsingEncoding:NSUTF8StringEncoding]];
            [body appendData:[NSData dataWithContentsOfURL:[NSURL URLWithString:report.movie]]];
            [body appendData:[[NSString stringWithFormat:@"\r\n--%@\r\n", boundary] dataUsingEncoding:NSUTF8StringEncoding]];
            //application/octet-stream video/quicktime
        }
    }
    

    [body appendData:[[NSString stringWithFormat:@"\r\n--%@\r\n", boundary] dataUsingEncoding:NSUTF8StringEncoding]];
    
    [urlRequest addValue: [NSString stringWithFormat:@"%d", [body length]] forHTTPHeaderField:@"Content-Length"];
    [urlRequest setHTTPBody: body];
    //    [urlRequest setHTTPBodyStream:[NSInputStream inputStreamWithData:body]];
    
    NSURLConnection *theCon = [[NSURLConnection alloc] initWithRequest:urlRequest delegate:self];
    [UIApplication sharedApplication].networkActivityIndicatorVisible = YES;
    if (theCon!=nil) {
        NSLog(@"%s [%d]: %@", __PRETTY_FUNCTION__, __LINE__, theCon);
    }
//    [url release];
//    [boundary release];
//    [body release];
//    [urlRequest release];

}

#pragma mark -
#pragma mark NSURLConnection delegate methods

- (void)connection:(NSURLConnection *)connection didReceiveResponse:(NSURLResponse *)response {
    self.rawData = [NSMutableData data];
    //Coolkie///////////////////////////
	NSURL *cookieUrl = [NSURL URLWithString:[[response URL] host]];
	NSHTTPURLResponse *urlResponse = (NSHTTPURLResponse *)response;
    NSArray *allCookies = [NSHTTPCookie cookiesWithResponseHeaderFields:[urlResponse allHeaderFields] forURL:cookieUrl];
	NSLog(@"%s [%d]: [allCookies count]: %d", __PRETTY_FUNCTION__, __LINE__, [allCookies count]);
    if ([allCookies count]) {
        [[NSHTTPCookieStorage sharedHTTPCookieStorage] setCookies:allCookies forURL:cookieUrl mainDocumentURL:nil];
	}
	//Coolkie///////////////////////////
}

- (void)connection:(NSURLConnection *)connection didReceiveData:(NSData *)data {
    [self.rawData appendData:data];
}

- (void)connection:(NSURLConnection *)connection didFailWithError:(NSError *)error {
    [UIApplication sharedApplication].networkActivityIndicatorVisible = NO;
    if ([error code] == kCFURLErrorNotConnectedToInternet) {
        NSDictionary *userInfo = [NSDictionary dictionaryWithObject:@"No Connection Error" forKey:NSLocalizedDescriptionKey];
        NSError *noConnectionError = [NSError errorWithDomain:NSCocoaErrorDomain code:kCFURLErrorNotConnectedToInternet userInfo:userInfo];
        [self handleError:noConnectionError];
    } else {
        [self handleError:error];
    }
    
    //Codes for Leak .... 
    [connection release];
    NSURLCache *sharedCache = [[NSURLCache alloc] initWithMemoryCapacity:0 diskCapacity:0 diskPath:nil];
    [NSURLCache setSharedURLCache:sharedCache];
    [sharedCache release];
}

- (void)connectionDidFinishLoading:(NSURLConnection *)connection {
    
    //Codes for Leak .... 
    [connection release];
    NSURLCache *sharedCache = [[NSURLCache alloc] initWithMemoryCapacity:0 diskCapacity:0 diskPath:nil];
    [NSURLCache setSharedURLCache:sharedCache];
    [sharedCache release];
    
    [UIApplication sharedApplication].networkActivityIndicatorVisible = NO;   
    
    NSLog(@"rawData: %@", [[[NSString alloc] initWithData:rawData encoding:NSUTF8StringEncoding] autorelease]);
    
    NSMutableDictionary *xmlDic = [[NSMutableDictionary alloc] init];
    [xmlDic setObject:@"info" forKey:@"infoTag"];
    [xmlDic setObject:@"data" forKey:@"dataTag"];
    [xmlDic 
     setObject:[NSArray arrayWithObjects:@"result", @"msg", nil] 
     forKey:@"infoFields"];
    [xmlDic setObject:[NSArray arrayWithObjects:@"rowid", @"subject", @"writer", @"reg_id", @"reg_date", @"type", @"publish", @"cryptid", @"latitude", @"longitude", @"content", nil] forKey:@"dataFields"];
    
    OWLXMLParser *parser = [[OWLXMLParser alloc] initWithData:rawData delegate:self xmlInfo:xmlDic];
    [parser startParse];
    [parser release];
    [xmlDic release];
    
    self.rawData = nil;
    
}

- (void)handleError:(NSError *)error {
    NSString *errorMessage = [error localizedDescription];
    UIAlertView *alertView = [[UIAlertView alloc] initWithTitle:@"Cannot Connect to Server." message:errorMessage delegate:nil cancelButtonTitle:@"OK" otherButtonTitles:nil];
    [alertView show];
    [alertView release];
}


#pragma mark -
#pragma mark XMLParse handle methods

- (void)didFinishParsing:(NSMutableDictionary *) resultDic {
    [self performSelectorOnMainThread:@selector(handleLoadedApps:) withObject:resultDic waitUntilDone:NO];
}

- (void)parseErrorOccurred:(NSError *)error {
    [self performSelectorOnMainThread:@selector(handleError:) withObject:error waitUntilDone:NO];
}

- (void)handleLoadedApps:(NSMutableDictionary *)loadedDic {
    int result = [[[loadedDic objectForKey:@"info"] objectForKey:@"result"] intValue];
    BOOL alertState = YES;
    if (result == 1) {
        NSMutableDictionary *dataTmp = [[[loadedDic objectForKey:@"data"] objectAtIndex:0] copy];
        
        report.rowid = [self string2Number:[dataTmp objectForKey:@"rowid"]];
        report.writer = [dataTmp objectForKey:@"writer"];
        report.subject = [dataTmp objectForKey:@"subject"];
        report.content = [dataTmp objectForKey:@"content"];
        report.reg_date = [self getDateTimeFromString:[dataTmp objectForKey:@"reg_date"]];
        report.reg_id = [dataTmp objectForKey:@"reg_id"];
        report.type = [dataTmp objectForKey:@"type"];
        report.publish = [self string2Number:[dataTmp objectForKey:@"publish"]];
        report.cryptid = [dataTmp objectForKey:@"cryptid"];
        report.latitude = [dataTmp objectForKey:@"latitude"];
        report.longitude = [dataTmp objectForKey:@"longitude"];
        report.local_state = @"";

        NSError *error = nil;
        if (![report.managedObjectContext save:&error]) {
            NSLog(@"Unresolved error %@, %@", error, [error userInfo]);
            abort();
        } 
        [dataTmp release];
        [self viewWillAppear:YES];
    }
    
    if (alertState) {
        UIAlertView *alertView = [[UIAlertView alloc] initWithTitle:@"요청결과" message:@"" delegate:self cancelButtonTitle:@"확인" otherButtonTitles:nil];
        alertView.message = [[loadedDic objectForKey:@"info"] objectForKey:@"msg"];
        [alertView show];
        [alertView release];
    }
    
}

#pragma mark -
#pragma mark Upload methods

- (NSString *) makeBoundaryString {
    CFUUIDRef       uuid;
    CFStringRef     uuidStr;
    NSString *      result;
    
    uuid = CFUUIDCreate(NULL);
    assert(uuid != NULL);
    
    uuidStr = CFUUIDCreateString(NULL, uuid);
    assert(uuidStr != NULL);
    
    result = [NSString stringWithFormat:@"Boundary-%@", uuidStr];
    
    CFRelease(uuidStr);
    CFRelease(uuid);
    
    return result;
}

#pragma mark -
#pragma mark Utils 

- (NSDate *) getDateTimeFromString:(NSString *) dateString {
	NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
	[dateFormatter setDateFormat:@"yyyy-MM-dd HH:mm:ss"];
	NSDate *theDate = [dateFormatter dateFromString:dateString];
	[dateFormatter release];
	return theDate;
}

- (NSNumber *) string2Number:(NSString *) str {
    NSNumberFormatter *f = [[NSNumberFormatter alloc] init];
    [f setNumberStyle:NSNumberFormatterDecimalStyle];
    NSNumber *theNumber = [f numberFromString:str];
    [f release];
	return theNumber;
}


@end
