
#import "userInfo.h"

#pragma mark -
#pragma mark making the SSL Allowed.. 
@interface NSURLRequest (DummyInterface)
+ (BOOL)allowsAnyHTTPSCertificateForHost:(NSString*)host;
+ (void)setAllowsAnyHTTPSCertificate:(BOOL)allow forHost:(NSString*)host;
@end

@implementation userInfo

@synthesize scrollView;
@synthesize inputActive;
@synthesize myInfo, viewMode;
@synthesize queryString, queryData, urlCon, rawData, dicData;


#pragma mark -
#pragma mark View lifecycle

- (void)viewDidLoad {
	[super viewDidLoad];
	myInfo = [[NSMutableDictionary alloc] init];
	[self initScrollView];
	[self initTextFields];
	
}

- (void) viewWillAppear:(BOOL)animated {
	
	[super viewWillAppear:animated];
	
	[UIView beginAnimations:nil context:NULL];
	[UIView setAnimationDuration:1.5];
	[UIView setAnimationBeginsFromCurrentState:YES];
	[UIView setAnimationTransition:UIViewAnimationTransitionFlipFromLeft forView:self.navigationController.view cache:NO];
	[UIView commitAnimations];
	
	NSString* imageURL = @"http://www.owllab.com/ios/user_addhint.php";
	NSData* imageData = [[NSData alloc]initWithContentsOfURL:[NSURL URLWithString:imageURL]];
	
	UIImage* image = [[UIImage alloc] initWithData:imageData];
	[hintImageView setImage:image];
	[imageData release];
	[image release];
	[imageURL release];
	
	
	NSLog(@"super.tabBarController.selectedIndex:%d", super.tabBarController.selectedIndex);
	
	NSLog(@"%s [%d]: myInfo: %@", __PRETTY_FUNCTION__, __LINE__, myInfo);
	
	[self getCookies];
	if (viewMode==@"addView") {
		if ([[myInfo objectForKey:@"suserdb.userid"] length]>0) {
			UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"로그아웃안내" message:@"이미 로그인하셨습니다.\n로그아웃하시겠습니까?" delegate:self cancelButtonTitle:@"아니오" otherButtonTitles:@"로그아웃", nil];
			[alert show];
			[alert release];
		} else {
			[self getCookies];
		}
		
	} else {
		NSLog(@"%@", [myInfo objectForKey:@"suserdb.userid"]);
		if ([[myInfo objectForKey:@"suserdb.userid"] length]>0) {
			self.viewMode = @"editView";
		} else {
			UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"로그인안내" message:@"먼저 로그인하세요.\n로그인하시겠습니까?" delegate:self cancelButtonTitle:@"아니오" otherButtonTitles:@"로그인", nil];
			[alert show];
			[alert release];
			[self viewDidDisappear:YES];
		}
	}
	
	if (viewMode==@"editView") {
		self.navigationItem.title = @"My Info";
		[self.scrollView setAlpha:1.0];
		[outBtn setEnabled:YES];
		[outBtn setAlpha:0.7];
		inputID.enabled = NO;
		inputPWD.placeholder = @"기존 암호를 입력하세요.";
		inputPWDRe.placeholder = @"변경할 암호를 입력하세요.";
		saveBtn.titleLabel.text = @"수정합니다.";
		[self getURLData];
	} else if (viewMode==@"addView") {
		self.navigationItem.title = @"Create User ID";
		[self.scrollView setAlpha:1.0];
		[outBtn setEnabled:NO];
		[outBtn setAlpha:0.0];
		inputPWDRe.placeholder = @"암호 재확인";
		saveBtn.titleLabel.text = @"신청합니다.";
		
		//실험용 테이터
		/*
		//inputPhone.text = [[NSUserDefaults standardUserDefaults] stringForKey:@"SBFormattedPhoneNumber"];
		//[[UIDevice currentDevice] name];
		//[[UIDevice currentDevice] uniqueIdentifier];
		inputPhone.text = @"1111111111";
		inputID.text = @"test";
		inputPWD.text = @"111111";
		inputPWDRe.text = @"111111";
		inputName.text = @"테스터";
		inputAlias.text = @"테테테";
		inputEmail.text = @"test@owl.co.kr";
		inputPostal.text = @"111111";
		inputAddress.text = @"서울 강남 신사동 534-23";
		 */
	} else {
		[self.scrollView setAlpha:0.0];
	}
	
}

- (void)viewDidDisappear:(BOOL)animated {
	[super viewDidDisappear:animated];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}

- (void)viewDidUnload {
    [super viewDidUnload];
}


- (void)dealloc {
	[scrollView release];
	[inputActive release];
	[queryString release];
	[queryData release];
	[urlCon release];
	[rawData release];
	[dicData release];
	[myInfo release];
	
    [super dealloc];
}


#pragma mark -
#pragma mark Auto Scroll to Focused TextField

static CGFloat keyboardGap = 50.0;

- (void) initScrollView {
	[[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(keyboardWillAppear:) name:UIKeyboardWillShowNotification object:nil];
	[[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(keyboardWillDisappear:) name:UIKeyboardWillHideNotification object:nil];
	
	[scrollView setContentSize:CGSizeMake(self.view.frame.size.width, self.view.frame.size.height + 100)];
	[scrollView setClipsToBounds:YES];
	[scrollView setFrame:CGRectMake(0, 0, self.view.frame.size.width, self.view.frame.size.height)];
}

- (void) initTextFields {
	[inputPhone setLeftView:[[UIImageView alloc] initWithImage:[UIImage imageNamed:@"essential.png"]]];
	[inputPhone setLeftViewMode:UITextFieldViewModeUnlessEditing];
	
	[inputID setLeftView:[[UIImageView alloc] initWithImage:[UIImage imageNamed:@"essential.png"]]];
	[inputID setLeftViewMode:UITextFieldViewModeUnlessEditing];
	
	[inputPWD setLeftView:[[UIImageView alloc] initWithImage:[UIImage imageNamed:@"essential.png"]]];
	[inputPWD setLeftViewMode:UITextFieldViewModeUnlessEditing];
	
	[inputPWDRe setLeftView:[[UIImageView alloc] initWithImage:[UIImage imageNamed:@"essential.png"]]];
	[inputPWDRe setLeftViewMode:UITextFieldViewModeUnlessEditing];
	
	[inputName setLeftView:[[UIImageView alloc] initWithImage:[UIImage imageNamed:@"essential.png"]]];
	[inputName setLeftViewMode:UITextFieldViewModeUnlessEditing];
	
	[inputAlias setLeftView:[[UIImageView alloc] initWithImage:[UIImage imageNamed:@"essential.png"]]];
	[inputAlias setLeftViewMode:UITextFieldViewModeUnlessEditing];
	
	[inputEmail setLeftView:[[UIImageView alloc] initWithImage:[UIImage imageNamed:@"essential.png"]]];
	[inputEmail setLeftViewMode:UITextFieldViewModeUnlessEditing];
	
	[inputHint setLeftView:[[UIImageView alloc] initWithImage:[UIImage imageNamed:@"essential.png"]]];
	[inputHint setLeftViewMode:UITextFieldViewModeUnlessEditing];
}


- (void) keyboardWillAppear: (NSNotification *)Notification {
	NSDictionary* infoDic = [Notification userInfo];
	NSValue* keyboardInfo = [infoDic objectForKey:UIKeyboardFrameEndUserInfoKey];
	CGSize keyboardSize = [keyboardInfo CGRectValue].size;
	[scrollView setFrame:CGRectMake(scrollView.frame.origin.x, scrollView.frame.origin.y, scrollView.frame.size.width, scrollView.frame.size.height - (keyboardSize.height - keyboardGap))];
	CGRect textFieldRect = [inputActive frame];
	[scrollView scrollRectToVisible: textFieldRect animated:YES];
	
	//	[scrollView setContentSize:CGSizeMake(self.view.frame.size.width, scrollView.contentSize.height + keyboardSize.height)];
	//	[scrollView setContentOffset:CGPointMake(scrollView.contentOffset.x, scrollView.contentOffset.y + keyboardSize.height)];
}

- (void) keyboardWillDisappear: (NSNotification *)Notification {
	NSDictionary* infoDic = [Notification userInfo];
	NSValue* keyboardInfo = [infoDic objectForKey:UIKeyboardFrameEndUserInfoKey];
	CGSize keyboardSize = [keyboardInfo CGRectValue].size;
	[scrollView setFrame:CGRectMake(scrollView.frame.origin.x, scrollView.frame.origin.y, scrollView.frame.size.width, scrollView.frame.size.height + (keyboardSize.height - keyboardGap))];
	
	//	[scrollView setContentSize:CGSizeMake(self.view.frame.size.width, scrollView.contentSize.height - keyboardSize.height)];
	//	[scrollView setContentOffset:CGPointMake(scrollView.contentOffset.x, scrollView.contentOffset.y - keyboardSize.height)];
}

- (BOOL) textFieldShouldReturn:(UITextField *)textfield {
	[textfield resignFirstResponder]; 
	return YES;
}

- (BOOL)textFieldShouldBeginEditing:(UITextField *)textField {
	inputActive = textField;
	return YES;
}


#pragma mark -
#pragma mark TextField Filter

- (BOOL) textField:(UITextField *)textField shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string {
	BOOL state = YES;
	if (string.length > 0) {
		int theChar = [string characterAtIndex:0];
		
		if (textField == inputPhone) {
			state = [self numberOnly:theChar];
			if ([[textField text] length]>10) state = NO;
		} else if (textField == inputID) {
			string = [string lowercaseString];
			state = [self numberAlphabetOnly:theChar];
			if ([[textField text] length]>=50) state = NO;
		} else if (textField == inputPWD) {
			if ([[textField text] length]>=10) state = NO;
		} else if (textField == inputPWDRe) {
			if ([[textField text] length]>=10) state = NO;
		} else if (textField == inputName) {
			if ([[textField text] length]>=50) state = NO;
		} else if (textField == inputAlias) {
			if ([[textField text] length]>=50) state = NO;
		} else if (textField == inputEmail) {
			//state = [self validateEmail:string];
			if ([[textField text] length]>=100) state = NO;
		} else if (textField == inputPostal) {
			if ([[textField text] length]>=6) state = NO;
		} else if (textField == inputAddress) {
			if ([[textField text] length]>=100) state = NO;
		} else if (textField == inputHint) {
			if ([[textField text] length]>=4) state = NO;
		}
	}
	
	return state;
	
}

- (BOOL) numberOnly:(int)theChar {
	BOOL state = NO;
	if (theChar >= 48 && theChar <= 57) state = YES;
	return state;
}

- (BOOL) numberAlphabetOnly:(int)theChar {
	BOOL state = NO;
	if ((theChar >= 48 && theChar <= 57) || (theChar >= 65 && theChar <= 90) || (theChar >= 97 && theChar <= 122)) state = YES;
	return state;
}

- (BOOL) validateEmail:(NSString *)text {
    NSString *Regex = @"[A-Z0-9a-z._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,4}"; 
    NSPredicate *Test = [NSPredicate predicateWithFormat:@"SELF MATCHES %@", Regex]; 
    return [Test evaluateWithObject:text];
}


#pragma mark -
#pragma mark Button Actions

- (IBAction) OutAct:(id)sendor {
	if (inputPWD.text.length < 4) {
		[self alertInput:inputPWD withMessage:@"암호를 4자이상 입력하세요."];
	} else if (inputHint.text.length < 4) {
		[self alertInput:inputHint withMessage:@"등록코드를 올바르게 입력하세요."];
	} else {
		UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"탈퇴확인" message:@"정말로 탈퇴하시겠습니까?" delegate:self cancelButtonTitle:@"확인" otherButtonTitles:@"취소", nil];
		[alert show];
		[alert release];
	}
}

- (IBAction) CancelAct:(id)sendor {
	[self.navigationController popViewControllerAnimated:YES];
}

- (IBAction) SaveAct:(id)sendor {
	
	if (inputPhone.text.length < 10) {
		[self alertInput:inputPhone withMessage:@"휴대전화번호가 올바르지 않습니다."];
	} else if (inputID.text.length < 4) {
		[self alertInput:inputID withMessage:@"아이디를 4자이상 입력하세요."];
	} else if (inputPWD.text.length < 4) {
		[self alertInput:inputPWD withMessage:@"암호를 4자이상 입력하세요."];
	} else if (![self.viewMode isEqualToString:@"editView"] && [inputPWD.text isEqualToString:inputPWDRe.text]==NO) {
		[self alertInput:inputPWDRe withMessage:@"암호를 올바르게 입력하세요."];
	} else if (inputName.text.length < 2) {
		[self alertInput:inputName withMessage:@"이름을 2자이상 입력하세요."];
	} else if (inputAlias.text.length < 2) {
		[self alertInput:inputAlias withMessage:@"별명을 2자이상 입력하세요."];
	} else if ([self validateEmail:inputEmail.text]==NO) {
		[self alertInput:inputEmail withMessage:@"이메일을 올바르게 입력하세요."];
	} else if (inputHint.text.length < 4) {
		[self alertInput:inputHint withMessage:@"등록코드를 올바르게 입력하세요."];
	} else {
		if ([self.viewMode isEqualToString:@"editView"]) {
			self.viewMode = @"edit";
		}
		[self getURLData];
		[inputActive resignFirstResponder];
	}
	
}

#pragma mark -
#pragma mark UIAlertView and Delegate

- (void) alertInput:(UITextField *)textfield withMessage:(NSString *)msg {
	inputActive = textfield;
	UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"입력안내" message:msg delegate:self cancelButtonTitle:@"확인" otherButtonTitles:nil];
	[alert show];
	[alert release];
}

- (void) alertView:(UIAlertView *)actionSheet clickedButtonAtIndex:(NSInteger)buttonIndex {
	if ([actionSheet title] == @"입력안내") {
		[inputActive becomeFirstResponder];
	} else if ([actionSheet title] == @"요청결과") {
		
	} else if ([actionSheet title] == @"로그인안내") {
		if (buttonIndex==0) {
			[self.navigationController popViewControllerAnimated:YES];
		} else {
			[self selectTabBar:@"Login"];
		}
		
	} else if ([actionSheet title] == @"로그아웃안내") {
		if (buttonIndex==0) {
			[self.navigationController popViewControllerAnimated:YES];
		} else {
			[self selectTabBar:@"Logout"];
		}
		
	} else if ([actionSheet title] == @"탈퇴확인") {
		if (buttonIndex==0) {
			self.viewMode = @"del";
			[self getURLData];
		}
	}
}


#pragma mark -
#pragma mark NSURLConnection

- (void) getURLData {
	
	/*
	 등록인증번호 실험주소 :
	 http://www.owllab.com/ios/user_addhint.php
	 
	 1. 등록실험주소 :
	 http://www.owllab.com/ios/user_proc.php?mode=add&phone=1111111111&userid=test&passwd=111111&name=%ED%85%8C%EC%8A%A4%ED%84%B0&alias=%ED%85%8C%ED%85%8C%ED%85%8C&email=test@owl.co.kr&postal=111111&address=%EC%84%9C%EC%9A%B8%20%EA%B0%95%EB%82%A8%20%EC%8B%A0%EC%82%AC%EB%8F%99%20534-23&addhint=9471
	 
	 2. 수정실험주소 : 로그인 후 실험가능
	 http://www.owllab.com/ios/user_proc.php?mode=edit&phone=1111111111&userid=test&passwd=111111&name=%ED%85%8C%EC%8A%A4%ED%84%B0&alias=%ED%85%8C%ED%85%8C%ED%85%8C&email=test@owl.co.kr&postal=111111&address=%EC%84%9C%EC%9A%B8%20%EA%B0%95%EB%82%A8%20%EC%8B%A0%EC%82%AC%EB%8F%99%20534-23&addhint=&addhint=9471
	 
	 3. 나의정보 실험주소 : 로그인 후 실험가능
	 http://www.owllab.com/ios/user_proc.php
	 */
	
	[dicData release];
	dicData = [[NSMutableDictionary alloc] init];
	
	NSString *url = @"https://www.owllab.com/ios/user_proc.php";
	
	//making the SSL Allowed.. /////////////////
	NSURL *URL = [NSURL URLWithString:url];
	[NSURLRequest setAllowsAnyHTTPSCertificate:YES forHost:[URL host]];
	//making the SSL Allowed.. /////////////////
	
	
	if ([self.viewMode isEqualToString:@"del"]) {
		queryString = @"mode=del";
	} else if ([self.viewMode  isEqualToString:@"editView"]) {
		queryString = @"";
	} else if ([self.viewMode  isEqualToString:@"edit"]) {
		queryString = [NSString 
					   stringWithFormat: @"mode=edit&phone=%@&userid=%@&passwd=%@&newpwd=%@&name=%@&alias=%@&email=%@&postal=%@&address=%@&addhint=%@", 
					   [inputPhone.text stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding], 
					   [inputID.text stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding],
					   [inputPWD.text stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding],
					   [inputPWDRe.text stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding],
					   [inputName.text stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding],
					   [inputAlias.text stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding],
					   [inputEmail.text stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding],
					   [inputPostal.text stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding],
					   [inputAddress.text stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding],
					   [inputHint.text stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding]
					   ];
	} else {
		queryString = [NSString 
					   stringWithFormat: @"mode=add&phone=%@&userid=%@&passwd=%@&name=%@&alias=%@&email=%@&postal=%@&address=%@&addhint=%@", 
					   [inputPhone.text stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding], 
					   [inputID.text stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding],
					   [inputPWD.text stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding],
					   [inputName.text stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding],
					   [inputAlias.text stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding],
					   [inputEmail.text stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding],
					   [inputPostal.text stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding],
					   [inputAddress.text stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding],
					   [inputHint.text stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding]
					   ];
	}
	
	queryData = [NSData dataWithBytes:[queryString UTF8String] length:[queryString length]];
	
	NSMutableURLRequest *urlRequest = [[NSMutableURLRequest alloc] initWithURL:[NSURL URLWithString: url]];
	
	[urlRequest addValue: @"application/x-www-form-urlencoded; charset=utf-8" forHTTPHeaderField:@"Content-Type"];
	[urlRequest addValue: [NSString stringWithFormat:@"%d", [queryData length]] forHTTPHeaderField:@"Content-Length"];
	[urlRequest setHTTPMethod:@"POST"];
	[urlRequest setHTTPBody: queryData];
	
	NSLog(@"url: %@", url);
	NSLog(@"queryData: %@", [[[NSString alloc] initWithData:queryData encoding:NSUTF8StringEncoding] autorelease]);
	//POST////////////////
	
    self.urlCon = [[[NSURLConnection alloc] initWithRequest:urlRequest delegate:self] autorelease];
    [UIApplication sharedApplication].networkActivityIndicatorVisible = YES;
	[url release];
	[urlRequest release];
	
}

#pragma mark -
#pragma mark NSURLConnection delegate methods

- (void)connection:(NSURLConnection *)connection didReceiveResponse:(NSURLResponse *)response {
	
	self.rawData = [NSMutableData data];
	
	//Coolkie///////////////////////////
	NSURL *cookieUrl = [NSURL URLWithString:[[response URL] host]];
	NSLog(@"%s [%d]: [[response URL] host]: %@", __PRETTY_FUNCTION__, __LINE__, [[response URL] host]);
	
	//saveing NSHTTPCookieStorage
	NSHTTPURLResponse *urlResponse = (NSHTTPURLResponse *)response;
    NSArray *allCookies = [NSHTTPCookie cookiesWithResponseHeaderFields:[urlResponse allHeaderFields] forURL:cookieUrl];
	NSLog(@"%s [%d]: [allCookies count]: %d", __PRETTY_FUNCTION__, __LINE__, [allCookies count]);
    if ([allCookies count]) {
        [[NSHTTPCookieStorage sharedHTTPCookieStorage] setCookies:allCookies forURL:cookieUrl mainDocumentURL:nil];
	}
	
	//checing NSHTTPCookie
	for (int c=0; c<[allCookies count]; c++) {
		NSLog(@"%s [%d]: %@: %@, %@", __PRETTY_FUNCTION__, __LINE__, [[allCookies objectAtIndex:c] name], [[allCookies objectAtIndex:c] value], [[allCookies objectAtIndex:c] expiresDate]);
	}
	
	//checking NSHTTPCookieStorage
	NSArray *cookiea = [[NSHTTPCookieStorage sharedHTTPCookieStorage] cookies];
	NSLog(@"%s [%d]: [cookiea count]: %d", __PRETTY_FUNCTION__, __LINE__, [cookiea count]);
	for (int c=0; c<[cookiea count]; c++) {
		NSLog(@"%s [%d]: %@: %@", __PRETTY_FUNCTION__, __LINE__, [[cookiea objectAtIndex:c] name], [[cookiea objectAtIndex:c] value]);
	}
	
	//Coolkie///////////////////////////
}

- (void)connection:(NSURLConnection *)connection didReceiveData:(NSData *)data {
    [self.rawData appendData:data];
}

- (void)connection:(NSURLConnection *)connection didFailWithError:(NSError *)error {
    [UIApplication sharedApplication].networkActivityIndicatorVisible = NO;
    if ([error code] == kCFURLErrorNotConnectedToInternet) {
        NSDictionary *userInfo = [NSDictionary dictionaryWithObject:@"No Connection Error" forKey:NSLocalizedDescriptionKey];
        NSError *noConnectionError = [NSError errorWithDomain:NSCocoaErrorDomain code:kCFURLErrorNotConnectedToInternet userInfo:userInfo];
        [self handleError:noConnectionError];
    } else {
        [self handleError:error];
    }
    
    self.urlCon = nil;
}

- (void)connectionDidFinishLoading:(NSURLConnection *)connection {
    self.urlCon = nil;
	
    [UIApplication sharedApplication].networkActivityIndicatorVisible = NO;   
    
	NSLog(@"rawData: %@", [[[NSString alloc] initWithData:rawData encoding:NSUTF8StringEncoding] autorelease]);
	
	NSMutableDictionary *xmlDic = [[NSMutableDictionary alloc] init];
	[xmlDic setObject:@"info" forKey:@"infoTag"];
	[xmlDic setObject:@"data" forKey:@"dataTag"];
	[xmlDic 
	 setObject:[NSArray arrayWithObjects:@"result", @"totrec", @"msg", nil] 
	 forKey:@"infoFields"];
	[xmlDic 
	 setObject:[NSArray arrayWithObjects:@"rowid", @"phone", @"userid", @"name", @"alias", @"email", @"postal", @"address", @"userlevel", nil] 
	 forKey:@"dataFields"];
	
	OWLXMLParser *parser = [[OWLXMLParser alloc] initWithData:rawData delegate:self xmlInfo:xmlDic];
	[parser startParse];
	[parser release];
	[xmlDic release];
	
	self.rawData = nil;
}

- (void)handleError:(NSError *)error {
	
    NSString *errorMessage = [error localizedDescription];
    UIAlertView *alertView = [[UIAlertView alloc] initWithTitle:@"Cannot Connect to Server." message:errorMessage delegate:nil cancelButtonTitle:@"OK" otherButtonTitles:nil];
    [alertView show];
    [alertView release];

}


#pragma mark -
#pragma mark XMLParse handle methods

- (void)didFinishParsing:(NSMutableDictionary *) resultDic {
	[self performSelectorOnMainThread:@selector(handleLoadedApps:) withObject:resultDic waitUntilDone:NO];
}

- (void)parseErrorOccurred:(NSError *)error {
    [self performSelectorOnMainThread:@selector(handleError:) withObject:error waitUntilDone:NO];
}

- (void)handleLoadedApps:(NSMutableDictionary *)loadedDic {
	int result = [[[loadedDic objectForKey:@"info"] objectForKey:@"result"] intValue];
	BOOL alertState = YES;
	if (result == 1) {
		if ([self.viewMode isEqualToString:@"del"]) {
			[myInfo removeAllObjects];
			[self deleteAllCookies];
			self.viewMode = @"";
			[self.navigationController popViewControllerAnimated:YES];
		} else if ([self.viewMode isEqualToString:@"edit"] || [self.viewMode isEqualToString:@"editView"]) {
			NSMutableDictionary *myInfoTmp = [[loadedDic objectForKey:@"data"] objectAtIndex:0];
			inputPhone.text = [myInfoTmp objectForKey:@"phone"];
			inputID.text = [myInfoTmp objectForKey:@"userid"];
			inputName.text = [myInfoTmp objectForKey:@"name"];
			inputAlias.text = [myInfoTmp objectForKey:@"alias"];
			inputEmail.text = [myInfoTmp objectForKey:@"email"];
			inputPostal.text = [myInfoTmp objectForKey:@"postal"];
			inputAddress.text = [myInfoTmp objectForKey:@"address"];
			
			inputPWD.text = @"";
			inputPWDRe.text = @"";
			inputHint.text = @"";
			
			alertState = NO;
			if ([self.viewMode isEqualToString:@"edit"]) {
				self.viewMode = @"editView";
				alertState = YES;
			}
		} else {
			[self selectTabBar:@"Logout"];
			[self.navigationController popViewControllerAnimated:YES];
		}
	} else if (result == -5) {
		[self deleteAllCookies];
		[self selectTabBar:@"Login"];
	}
	
	if (alertState) {
		UIAlertView *alertView = [[UIAlertView alloc] initWithTitle:@"요청결과" message:@"" delegate:self cancelButtonTitle:@"확인" otherButtonTitles:nil];
		alertView.message = [[loadedDic objectForKey:@"info"] objectForKey:@"msg"];
		[alertView show];
		[alertView release];
	}
	
}

#pragma mark -
#pragma mark NSHTTPCookieStorage Utils

- (void) deleteAllCookies {
	for (NSHTTPCookie *each in [[[[NSHTTPCookieStorage sharedHTTPCookieStorage] cookies] copy] autorelease]) {
        [[NSHTTPCookieStorage sharedHTTPCookieStorage] deleteCookie:each];
    }
}

- (void) getCookies {
	[myInfo removeAllObjects];
	NSArray *cookiea = [[NSHTTPCookieStorage sharedHTTPCookieStorage] cookies];
	for (int c=0; c<[cookiea count]; c++) {
		[myInfo setObject:[[cookiea objectAtIndex:c] value] forKey:[[cookiea objectAtIndex:c] name]];
		NSLog(@"%s [%d]: %@: %@", __PRETTY_FUNCTION__, __LINE__, [[cookiea objectAtIndex:c] name], [[cookiea objectAtIndex:c] value]);
	}
}

#pragma mark -
#pragma mark Change tabBarController

- (void) selectTabBar:(NSString *) title {
	BOOL found = NO;
	UITabBarController *tabBarCtrl = super.tabBarController;
	NSArray *viewa = tabBarCtrl.viewControllers;
	for (int i=0; i<[viewa count];i++) {
		NSLog(@"%@", [[viewa objectAtIndex:i] nibName]);
		if ([[[viewa objectAtIndex:i] title] isEqualToString:title]) {
			tabBarCtrl.selectedIndex = i;
			found = YES;
			break;
		}
	}
	if (found==NO) {
		tabBarCtrl.selectedIndex = 0;
	}
}


@end
