
#import <Foundation/Foundation.h>

@protocol OWLXMLParserDelegate;

@interface OWLXMLParser : NSObject <NSXMLParserDelegate> {
	
	NSString *infoTag;
	NSString *dataTag;
	NSArray *infoFields;
	NSArray *dataFields;
	NSMutableDictionary *resultDic;
	NSMutableString *workingPropertyString;
    NSArray         *elementsToParse;
    BOOL            storingCharacterData;
	
}

@property (nonatomic, retain) NSString *infoTag;
@property (nonatomic, retain) NSString *dataTag;
@property (nonatomic, retain) NSArray *infoFields;
@property (nonatomic, retain) NSArray *dataFields;
@property (nonatomic, retain) NSMutableDictionary *resultDic;
@property (nonatomic, assign) id <OWLXMLParserDelegate> delegate;
@property (nonatomic, retain) NSData *dataToParse;
@property (nonatomic, retain) NSMutableString *workingPropertyString;
@property (nonatomic, assign) BOOL storingCharacterData;

- (id)initWithData:(NSData *)data delegate:(id <OWLXMLParserDelegate>)theDelegate xmlInfo:(NSMutableDictionary *)xmlDic;
- (void)startParse;

@end

@protocol OWLXMLParserDelegate
- (void)didFinishParsing:(NSMutableDictionary *) resultDic;
- (void)parseErrorOccurred:(NSError *)error;
@end
