
@class Report;

@protocol smartWriteDelegate;

@interface smartWriter : UIViewController <UITextFieldDelegate> {
@private
	Report *report;
	IBOutlet UITextField *inputSubject;
	IBOutlet UITextField *inputWriter;
	IBOutlet UITextField *inputUserid;
	id <smartWriteDelegate> delegate;
	
	NSMutableDictionary *myInfo;
}

@property(nonatomic, retain) Report *report;
@property(nonatomic, assign) id <smartWriteDelegate> delegate;

@property (nonatomic, retain) NSMutableDictionary *myInfo;

- (void)save;
- (void)cancel;
- (void) getCookies;

@end

@protocol smartWriteDelegate <NSObject>
- (void) viewController:(smartWriter *)ViewController didWrite:(Report *)report;
@end
