
#import "typeView.h"
#import "Report.h"
#import "ReportType.h"

@interface typeView()
@property (nonatomic, retain) NSArray *reportTypes;
@end

@implementation typeView

@synthesize report;
@synthesize reportTypes;


#pragma mark -
#pragma mark NSManagedObjectContext

- (void) getTypes {    
    NSManagedObjectContext *context = [report managedObjectContext];
	
	NSFetchRequest *fetchRequest = [[NSFetchRequest alloc] init];
	[fetchRequest setEntity:[NSEntityDescription entityForName:@"ReportType" inManagedObjectContext:context]];
	NSSortDescriptor *sortDescriptor = [[NSSortDescriptor alloc] initWithKey:@"name" ascending:YES];
	NSArray *sortDescriptors = [[NSArray alloc] initWithObjects:&sortDescriptor count:1];
	[fetchRequest setSortDescriptors:sortDescriptors];
	
	NSError *error = nil;
	NSArray *types = [context executeFetchRequest:fetchRequest error:&error];
	self.reportTypes = types;
	
	[fetchRequest release];
	[sortDescriptor release];
	[sortDescriptors release];
}

#pragma mark -
#pragma mark Table view data source

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}


- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return [reportTypes count];
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
	static NSString *CellIdentifier = @"Cell";
    
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil) {
        cell = [[[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:CellIdentifier] autorelease];
    }
    
    [self configureCell:cell atIndexPath:indexPath];
    return cell;
}

- (void)configureCell:(UITableViewCell *)cell atIndexPath:(NSIndexPath *)indexPath {
    cell.textLabel.text = [[reportTypes objectAtIndex:indexPath.row] valueForKey:@"name"];
    if ([report.type isEqualToString:cell.textLabel.text]) {
        cell.accessoryType = UITableViewCellAccessoryCheckmark;
    }
}


#pragma mark -
#pragma mark Table view delegate

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    if (report.type != nil) {
        for (int j=0;j<[reportTypes count];j++) {
            if ([[[reportTypes objectAtIndex:j] name] isEqualToString:report.type]) {
                NSIndexPath *selectionIndexPath = [NSIndexPath indexPathForRow:j inSection:0];
                UITableViewCell *checkedCell = [tableView cellForRowAtIndexPath:selectionIndexPath];
                checkedCell.accessoryType = UITableViewCellAccessoryNone;
            }
        }
    }
    
    [[tableView cellForRowAtIndexPath:indexPath] setAccessoryType:UITableViewCellAccessoryCheckmark]; 
    
    report.type = [[reportTypes objectAtIndex:indexPath.row] valueForKey:@"name"];
    
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
}


#pragma mark -
#pragma mark View lifecycle

- (void)viewDidLoad {
    [super viewDidLoad];
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
	[self getTypes];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    return (interfaceOrientation != UIInterfaceOrientationPortraitUpsideDown);
}


#pragma mark -
#pragma mark Memory management

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}

- (void)dealloc {
    [report release];
    [reportTypes release];
    
    [super dealloc];
}

@end

