
#import "userAgree.h"
#import "userInfo.h"

@implementation userAgree

@synthesize theSegment;
@synthesize myInfo;

// The designated initializer.  Override if you create the controller programmatically and want to perform customization that is not appropriate for viewDidLoad.
/*
 - (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil {
 self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
 if (self) {
 // Custom initialization.
 }
 return self;
 }
 */


- (void)viewDidLoad {
    [super viewDidLoad];
	myInfo = [[NSMutableDictionary alloc] init];
}

- (void) viewWillAppear:(BOOL)animated {
	
	[super viewWillAppear:animated];
	
	[UIView beginAnimations:nil context:NULL];
	[UIView setAnimationDuration:1.5];
	[UIView setAnimationBeginsFromCurrentState:YES];
	[UIView setAnimationTransition:UIViewAnimationTransitionCurlUp forView:self.navigationController.view cache:NO];
	[UIView commitAnimations];
	
	[self getCookies];
	BOOL loginState = NO;
	if ([[myInfo objectForKey:@"suserdb.userid"] length]>0) loginState = YES;
	
	NSLog(@"%s [%d]: suserdb.userid:%@",  __PRETTY_FUNCTION__, __LINE__, [myInfo objectForKey:@"suserdb.userid"]);
	
	if (loginState) {
		theSegment.hidden = YES;
	}
	
}

/*
 // Override to allow orientations other than the default portrait orientation.
 - (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
 // Return YES for supported orientations.
 return (interfaceOrientation == UIInterfaceOrientationPortrait);
 }
 */

- (void)didReceiveMemoryWarning {
    // Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
    
    // Release any cached data, images, etc. that aren't in use.
}

- (void)viewDidUnload {
    [super viewDidUnload];
    // Release any retained subviews of the main view.
    // e.g. self.myOutlet = nil;
}


- (void)dealloc {
	[myInfo release];
    [super dealloc];
}

#pragma mark -
#pragma mark IBActions

- (IBAction) goAddView:(id)sender{
	userInfo *detailViewController = [[userInfo alloc] initWithNibName:@"userInfo" bundle:nil];
	detailViewController.title = @"Create User ID";
	detailViewController.viewMode = @"addView";
	[self.navigationController pushViewController:detailViewController animated:YES];
}

- (IBAction) goMain:(id)sender {
	super.tabBarController.selectedIndex = 0;
}

- (IBAction) confirmBtn:(id)sender {
	if ([sender selectedSegmentIndex]==0) {
		[self goAddView:sender];
	} else if ([sender selectedSegmentIndex]==1) {
		[self goMain:sender];
	}
	theSegment.selectedSegmentIndex = -1;
}

#pragma mark -
#pragma mark NSHTTPCookieStorage Utils

- (void) getCookies {
	[myInfo removeAllObjects];
	NSArray *cookiea = [[NSHTTPCookieStorage sharedHTTPCookieStorage] cookies];
	for (int c=0; c<[cookiea count]; c++) {
		[myInfo setObject:[[cookiea objectAtIndex:c] value] forKey:[[cookiea objectAtIndex:c] name]];
		NSLog(@"%s [%d]: %@: %@", __PRETTY_FUNCTION__, __LINE__, [[cookiea objectAtIndex:c] name], [[cookiea objectAtIndex:c] value]);
	}
}

#pragma mark -
#pragma mark Change tabBarController

- (void) selectTabBar:(NSString *) title {
	BOOL found = NO;
	UITabBarController *tabBarCtrl = super.tabBarController;
	NSArray *viewa = tabBarCtrl.viewControllers;
	for (int i=0; i<[viewa count];i++) {
		NSLog(@"%@", [[viewa objectAtIndex:i] nibName]);
		if ([[[viewa objectAtIndex:i] title] isEqualToString:title]) {
			tabBarCtrl.selectedIndex = i;
			found = YES;
			break;
		}
	}
	if (found==NO) {
		tabBarCtrl.selectedIndex = 0;
	}
}


@end
