
#import "logoutView.h"
#import "loginView.h"

#pragma mark -
#pragma mark making the SSL Allowed.. 
@interface NSURLRequest (DummyInterface)
+ (BOOL)allowsAnyHTTPSCertificateForHost:(NSString*)host;
+ (void)setAllowsAnyHTTPSCertificate:(BOOL)allow forHost:(NSString*)host;
@end


@implementation logoutView

@synthesize queryString, queryData, urlCon, rawData, dicData;
@synthesize myInfo;

// The designated initializer.  Override if you create the controller programmatically and want to perform customization that is not appropriate for viewDidLoad.
/*
 - (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil {
 self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
 if (self) {
 // Custom initialization.
 }
 return self;
 }
 */


// Implement viewDidLoad to do additional setup after loading the view, typically from a nib.
- (void)viewDidLoad {
    [super viewDidLoad];
	myInfo = [[NSMutableDictionary alloc] init];
}

- (void) viewWillAppear:(BOOL)animated {
	[super viewWillAppear:animated];
	[UIView beginAnimations:nil context:NULL];
	[UIView setAnimationDuration:1.5];
	[UIView setAnimationBeginsFromCurrentState:YES];
	[UIView setAnimationTransition:UIViewAnimationTransitionFlipFromLeft forView:self.navigationController.view cache:NO];
	[UIView commitAnimations];
	
	[self getCookies];
	inputID.text = [myInfo objectForKey:@"suserdb.userid"];
}

/*
 // Override to allow orientations other than the default portrait orientation.
 - (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
 // Return YES for supported orientations.
 return (interfaceOrientation == UIInterfaceOrientationPortrait);
 }
 */

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}

- (void)viewDidUnload {
    [super viewDidUnload];
}

- (void)dealloc {
	[queryString release];
	[queryData release];
	[urlCon release];
	[rawData release];
	[dicData release];
	[myInfo release];
	
    [super dealloc];
}

#pragma mark -
#pragma mark IBAction

- (IBAction) gotoMyInfo:(id)sender {
	[self selectTabBar:@"My Info"];
}

- (IBAction) gotoHelpDesk:(id)sender {
	[self selectTabBar:@"Help Desk"];
}

- (IBAction) tryToLogout:(id)sender {
	[self getURLData];
}

#pragma mark -
#pragma mark Change tabBarController

- (void) selectTabBar:(NSString *) title {
	BOOL found = NO;
	UITabBarController *tabBarCtrl = super.tabBarController;
	NSArray *viewa = tabBarCtrl.viewControllers;
	for (int i=0; i<[viewa count];i++) {
		NSLog(@"%@", [[viewa objectAtIndex:i] nibName]);
		if ([[[viewa objectAtIndex:i] title] isEqualToString:title]) {
			tabBarCtrl.selectedIndex = i;
			found = YES;
			break;
		}
	}
	if (found==NO) {
		tabBarCtrl.selectedIndex = 0;
	}
}

#pragma mark -
#pragma mark NSURLConnection

- (void) getURLData {
	
	[dicData release];
	dicData = [[NSMutableDictionary alloc] init];
	
	NSString *url = @"https://www.owllab.com/ios/login_proc.php";
	
	//making the SSL Allowed.. /////////////////
	NSURL *URL = [NSURL URLWithString:url];
	[NSURLRequest setAllowsAnyHTTPSCertificate:YES forHost:[URL host]];
	//making the SSL Allowed.. /////////////////
	
	
	queryString = [NSString stringWithFormat: @"mode=logout"];
	
	queryData = [NSData dataWithBytes:[queryString UTF8String] length:[queryString length]];
	
	NSMutableURLRequest *urlRequest = [[NSMutableURLRequest alloc] initWithURL:[NSURL URLWithString: url]];
	
	[urlRequest addValue: @"application/x-www-form-urlencoded; charset=utf-8" forHTTPHeaderField:@"Content-Type"];
	[urlRequest addValue: [NSString stringWithFormat:@"%d", [queryData length]] forHTTPHeaderField:@"Content-Length"];
	[urlRequest setHTTPMethod:@"POST"];
	[urlRequest setHTTPBody: queryData];
	
	NSLog(@"url: %@", url);
	NSLog(@"queryData: %@", [[[NSString alloc] initWithData:queryData encoding:NSUTF8StringEncoding] autorelease]);
	//POST////////////////
	
    self.urlCon = [[[NSURLConnection alloc] initWithRequest:urlRequest delegate:self] autorelease];
    [UIApplication sharedApplication].networkActivityIndicatorVisible = YES;
	[url release];
	[urlRequest release];
	
}

#pragma mark -
#pragma mark NSURLConnection delegate methods

- (void)connection:(NSURLConnection *)connection didReceiveResponse:(NSURLResponse *)response {
	
	self.rawData = [NSMutableData data];
	
	//Coolkie///////////////////////////
	NSURL *cookieUrl = [NSURL URLWithString:[[response URL] host]];
	NSLog(@"%s [%d]: [[response URL] host]: %@", __PRETTY_FUNCTION__, __LINE__, [[response URL] host]);
	
	//saveing NSHTTPCookieStorage
	NSHTTPURLResponse *urlResponse = (NSHTTPURLResponse *)response;
    NSArray *allCookies = [NSHTTPCookie cookiesWithResponseHeaderFields:[urlResponse allHeaderFields] forURL:cookieUrl];
	NSLog(@"%s [%d]: [allCookies count]: %d", __PRETTY_FUNCTION__, __LINE__, [allCookies count]);
    if ([allCookies count]) {
        [[NSHTTPCookieStorage sharedHTTPCookieStorage] setCookies:allCookies forURL:cookieUrl mainDocumentURL:nil];
	}
/*	
	//checing NSHTTPCookie
	for (int c=0; c<[allCookies count]; c++) {
		NSLog(@"%s [%d]: %@: %@, %@", __PRETTY_FUNCTION__, __LINE__, [[allCookies objectAtIndex:c] name], [[allCookies objectAtIndex:c] value], [[allCookies objectAtIndex:c] expiresDate]);
	}
	
	//checking NSHTTPCookieStorage
	NSArray *cookiea = [[NSHTTPCookieStorage sharedHTTPCookieStorage] cookies];
	NSLog(@"%s [%d]: [cookiea count]: %d", __PRETTY_FUNCTION__, __LINE__, [cookiea count]);
	for (int c=0; c<[cookiea count]; c++) {
		NSLog(@"%s [%d]: %@: %@", __PRETTY_FUNCTION__, __LINE__, [[cookiea objectAtIndex:c] name], [[cookiea objectAtIndex:c] value]);
	}
*/	
	//Coolkie///////////////////////////
}

- (void)connection:(NSURLConnection *)connection didReceiveData:(NSData *)data {
    [self.rawData appendData:data];
}

- (void)connection:(NSURLConnection *)connection didFailWithError:(NSError *)error {
    [UIApplication sharedApplication].networkActivityIndicatorVisible = NO;
    if ([error code] == kCFURLErrorNotConnectedToInternet) {
        NSDictionary *userInfo = [NSDictionary dictionaryWithObject:@"No Connection Error" forKey:NSLocalizedDescriptionKey];
        NSError *noConnectionError = [NSError errorWithDomain:NSCocoaErrorDomain code:kCFURLErrorNotConnectedToInternet userInfo:userInfo];
        [self handleError:noConnectionError];
    } else {
        [self handleError:error];
    }
    
    self.urlCon = nil;
}

- (void)connectionDidFinishLoading:(NSURLConnection *)connection {
    self.urlCon = nil;
    [UIApplication sharedApplication].networkActivityIndicatorVisible = NO;   
    
	NSLog(@"rawData: %@", [[[NSString alloc] initWithData:rawData encoding:NSUTF8StringEncoding] autorelease]);
	
	NSMutableDictionary *xmlDic = [[NSMutableDictionary alloc] init];
	[xmlDic setObject:@"info" forKey:@"infoTag"];
	[xmlDic setObject:@"data" forKey:@"dataTag"];
	[xmlDic 
	 setObject:[NSArray arrayWithObjects:@"result", @"msg", nil] 
	 forKey:@"infoFields"];
	[xmlDic 
	 setObject:[NSArray arrayWithObjects:@"rowid", @"phone", @"userid", @"name", @"alias", @"email", @"postal", @"address", @"userlevel", nil] 
	 forKey:@"dataFields"];
	
	OWLXMLParser *parser = [[OWLXMLParser alloc] initWithData:rawData delegate:self xmlInfo:xmlDic];
	[parser startParse];
	[parser release];
	[xmlDic release];
	
	self.rawData = nil;
}

- (void)handleError:(NSError *)error {
    NSString *errorMessage = [error localizedDescription];
    UIAlertView *alertView = [[UIAlertView alloc] initWithTitle:@"Cannot Connect to Server." message:errorMessage delegate:nil cancelButtonTitle:@"OK" otherButtonTitles:nil];
    [alertView show];
    [alertView release];
}


#pragma mark -
#pragma mark XMLParse handle methods

- (void)didFinishParsing:(NSMutableDictionary *) resultDic {
	[self performSelectorOnMainThread:@selector(handleLoadedApps:) withObject:resultDic waitUntilDone:NO];
}

- (void)parseErrorOccurred:(NSError *)error {
    [self performSelectorOnMainThread:@selector(handleError:) withObject:error waitUntilDone:NO];
}

- (void)handleLoadedApps:(NSMutableDictionary *)loadedDic {
	int result = [[[loadedDic objectForKey:@"info"] objectForKey:@"result"] intValue];
	BOOL alertState = YES;
	if (result == 1) {
		[self.navigationController popViewControllerAnimated:YES];
		[self selectTabBar:@"Login"];
	}
	if (alertState) {
		UIAlertView *alertView = [[UIAlertView alloc] initWithTitle:@"요청결과" message:@"" delegate:self cancelButtonTitle:@"확인" otherButtonTitles:nil];
		alertView.message = [[loadedDic objectForKey:@"info"] objectForKey:@"msg"];
		[alertView show];
		[alertView release];
	}
	
}

#pragma mark -
#pragma mark NSHTTPCookieStorage Utils

- (void) deleteAllCookies {
	for (NSHTTPCookie *each in [[[[NSHTTPCookieStorage sharedHTTPCookieStorage] cookies] copy] autorelease]) {
        [[NSHTTPCookieStorage sharedHTTPCookieStorage] deleteCookie:each];
    }
}

- (void) getCookies {
	[myInfo removeAllObjects];
	NSArray *cookiea = [[NSHTTPCookieStorage sharedHTTPCookieStorage] cookies];
	for (int c=0; c<[cookiea count]; c++) {
		[myInfo setObject:[[cookiea objectAtIndex:c] value] forKey:[[cookiea objectAtIndex:c] name]];
		NSLog(@"%s [%d]: %@: %@", __PRETTY_FUNCTION__, __LINE__, [[cookiea objectAtIndex:c] name], [[cookiea objectAtIndex:c] value]);
	}
}

@end
