
#import "smartReports.h"
#import "Report.h"
#import "smartView.h"
#import "ReportTableViewCell.h"


#pragma mark -
#pragma mark making the SSL Allowed.. 
@interface NSURLRequest (DummyInterface)
+ (BOOL)allowsAnyHTTPSCertificateForHost:(NSString*)host;
+ (void)setAllowsAnyHTTPSCertificate:(BOOL)allow forHost:(NSString*)host;
@end

@implementation smartReports

@synthesize managedObjectContext, fetchedResultsController;
@synthesize queryString, queryData, urlCon, rawData, dicData;
@synthesize lastid;

#pragma mark -
#pragma mark Fetched results controller

- (NSFetchedResultsController *)fetchedResultsController {
    
    if (fetchedResultsController == nil) {
		// NSFetchRequest => SQL Object
        NSFetchRequest *fetchRequest = [[NSFetchRequest alloc] init];
        
		// NSEntityDescription => Table
        NSEntityDescription *entity = [NSEntityDescription entityForName:@"Report" inManagedObjectContext:managedObjectContext];
        [fetchRequest setEntity:entity];
        NSLog(@"theSearchBar.text : %@", theSearchBar.text);
        if (theSearchBar.text!= nil && [theSearchBar.text length] > 0) {
            NSPredicate *pred = [NSPredicate predicateWithFormat:@"publish = 1 and subject like %@",[NSString stringWithFormat:@"*%@*", theSearchBar.text]];
            NSLog(@"NSPredicate : %@", pred);
            [fetchRequest setPredicate:pred];
        } else {
            NSPredicate *pred = [NSPredicate predicateWithFormat:@"publish = 1"];
            NSLog(@"NSPredicate : %@", pred);
            [fetchRequest setPredicate:pred];
        }
        
        // NSSortDescriptor => order by ~
        NSSortDescriptor *sortDescriptor = [[NSSortDescriptor alloc] initWithKey:@"reg_date" ascending:NO];
        NSArray *sortDescriptors = [[NSArray alloc] initWithObjects:sortDescriptor, nil];
        [fetchRequest setSortDescriptors:sortDescriptors];
        
        // NSFetchedResultsController => Results
        NSFetchedResultsController *aFetchedResultsController = [[NSFetchedResultsController alloc] initWithFetchRequest:fetchRequest managedObjectContext:managedObjectContext sectionNameKeyPath:nil cacheName:@"Root"];
        [NSFetchedResultsController deleteCacheWithName:nil];
        aFetchedResultsController.delegate = self;
        self.fetchedResultsController = aFetchedResultsController;
        
        [aFetchedResultsController release];
        [fetchRequest release];
        [sortDescriptor release];
        [sortDescriptors release];
    }
	
	return fetchedResultsController;
}

- (void)controllerWillChangeContent:(NSFetchedResultsController *)controller {
	[self.tableView beginUpdates];
}


- (void)controller:(NSFetchedResultsController *)controller didChangeObject:(id)anObject atIndexPath:(NSIndexPath *)indexPath forChangeType:(NSFetchedResultsChangeType)type newIndexPath:(NSIndexPath *)newIndexPath {
	UITableView *tableView = self.tableView;
	
	switch(type) {
		case NSFetchedResultsChangeInsert:
			[tableView insertRowsAtIndexPaths:[NSArray arrayWithObject:newIndexPath] withRowAnimation:UITableViewRowAnimationFade];
			break;
			
		case NSFetchedResultsChangeDelete:
			[tableView deleteRowsAtIndexPaths:[NSArray arrayWithObject:indexPath] withRowAnimation:UITableViewRowAnimationFade];
			break;
			
		case NSFetchedResultsChangeUpdate:
			[self configureCell:(ReportTableViewCell *)[tableView cellForRowAtIndexPath:indexPath] atIndexPath:indexPath];
			break;
			
		case NSFetchedResultsChangeMove:
			[tableView deleteRowsAtIndexPaths:[NSArray arrayWithObject:indexPath] withRowAnimation:UITableViewRowAnimationFade];
            [tableView insertRowsAtIndexPaths:[NSArray arrayWithObject:newIndexPath] withRowAnimation:UITableViewRowAnimationFade];
            break;
	}
}


- (void)controller:(NSFetchedResultsController *)controller didChangeSection:(id <NSFetchedResultsSectionInfo>)sectionInfo atIndex:(NSUInteger)sectionIndex forChangeType:(NSFetchedResultsChangeType)type {
	switch(type) {
		case NSFetchedResultsChangeInsert:
			[self.tableView insertSections:[NSIndexSet indexSetWithIndex:sectionIndex] withRowAnimation:UITableViewRowAnimationFade];
			break;
			
		case NSFetchedResultsChangeDelete:
			[self.tableView deleteSections:[NSIndexSet indexSetWithIndex:sectionIndex] withRowAnimation:UITableViewRowAnimationFade];
			break;
	}
}


- (void)controllerDidChangeContent:(NSFetchedResultsController *)controller {
	[self.tableView endUpdates];
}

- (void) loadReports {
    NSLog(@"%s [%d] fetchedResultsController start loading.....",__PRETTY_FUNCTION__, __LINE__);
    fetchedResultsController = nil;
    NSError *error = nil;
	if (![[self fetchedResultsController] performFetch:&error]) {
		NSLog(@"Unresolved error %@, %@", error, [error userInfo]);
		abort();
	}
}


#pragma mark -
#pragma mark Table view data source

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
	NSInteger count = [[fetchedResultsController sections] count];
	if (count == 0) {
		count = 1;
	}
    return count;
}


- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    NSInteger numberOfRows = 0;
    if ([[fetchedResultsController sections] count] > 0) {
        id <NSFetchedResultsSectionInfo> sectionInfo = [[fetchedResultsController sections] objectAtIndex:section];
        numberOfRows = [sectionInfo numberOfObjects];
    }
    return numberOfRows;
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    
    static NSString *CellIdentifier = @"Cell";
    
    ReportTableViewCell *cell = (ReportTableViewCell *)[tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil) {
        cell = [[[ReportTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:CellIdentifier] autorelease];
		cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
    }
	[self configureCell:cell atIndexPath:indexPath];
    
    return cell;
}


- (void)configureCell:(ReportTableViewCell *)cell atIndexPath:(NSIndexPath *)indexPath {
	Report *report = (Report *)[fetchedResultsController objectAtIndexPath:indexPath];
    cell.report = report;
}

#pragma mark -
#pragma mark Table view delegate

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
	Report *report = (Report *)[fetchedResultsController objectAtIndexPath:indexPath];
	[self showDetail:report];
}


#pragma mark -
#pragma mark UISearchBarDelegate

- (void)searchBarSearchButtonClicked:(UISearchBar *)searchBar {
	[theSearchBar resignFirstResponder];
	[self searchData];
}


- (void)searchBarCancelButtonClicked:(UISearchBar *)searchBar {
	[theSearchBar resignFirstResponder];
    [self searchData];
}

- (void)searchData {
    [self loadReports];
    [self.tableView reloadData];
}


#pragma mark -
#pragma mark Context Menu

- (void) addActionBtn {
	UIBarButtonItem *addButton = [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemAction  target:self action:@selector(contextMenu:)];
    [self.navigationItem setRightBarButtonItem:addButton];
	[addButton release];
}

- (IBAction) contextMenu:(id)sender {
	UIActionSheet *sheet = [[[UIActionSheet alloc] initWithTitle:nil delegate:nil cancelButtonTitle:nil destructiveButtonTitle:nil otherButtonTitles:nil] autorelease];
	[sheet addButtonWithTitle:@"Download New Smart Reports"];
    [sheet addButtonWithTitle:@"Delete All Listed News"];
    [sheet addButtonWithTitle:@"My Reports"];
	[sheet addButtonWithTitle:@"Cancel"];
	sheet.cancelButtonIndex = 3;
	sheet.delegate = self;
	[sheet showInView:self.view];
}

enum ArchiveActionSheetButtons {
	download,
    deleteAll,
    myReports
};

- (void) actionSheet:(UIActionSheet*)actionSheet clickedButtonAtIndex:(NSInteger)buttonIndex {
	switch(buttonIndex) {	
		case download: {
			[self getURLReports];
			break;
		}
        case deleteAll: {
			[self deleteAllListed];
			break;
		}
        case myReports: {
			[self selectTabBar:@"My Reports"];
			break;
		}
		default: {
			break;
		}
	}
}


#pragma mark -
#pragma mark Changing View support

- (void) showDetail:(Report *) report {
	smartView *detailViewController = [[smartView alloc] initWithStyle:UITableViewStyleGrouped];
    detailViewController.report = report;
    [self.navigationController pushViewController:detailViewController animated:YES];

}


#pragma mark -
#pragma mark Change tabBarController

- (void) selectTabBar:(NSString *) title {
	BOOL found = NO;
	UITabBarController *tabBarCtrl = super.tabBarController;
	NSArray *viewa = tabBarCtrl.viewControllers;
	for (int i=0; i<[viewa count];i++) {
		NSLog(@"%@", [[viewa objectAtIndex:i] nibName]);
		if ([[[viewa objectAtIndex:i] title] isEqualToString:title]) {
			tabBarCtrl.selectedIndex = i;
			found = YES;
			break;
		}
	}
	if (found==NO) {
		tabBarCtrl.selectedIndex = 0;
	}
}


#pragma mark -
#pragma mark NSURLConnection

- (void) getURLReports {
	
	/*
	 실험주소 :
	 http://www.owllab.com/ios/smartreports.php
	 */
    
	[dicData release];
	dicData = [[NSMutableDictionary alloc] init];
	
	NSString *url = @"https://www.owllab.com/ios/smartreports.php";
	
	//making the SSL Allowed.. /////////////////
	NSURL *URL = [NSURL URLWithString:url];
	[NSURLRequest setAllowsAnyHTTPSCertificate:YES forHost:[URL host]];
	//making the SSL Allowed.. /////////////////
    
    if (lastid==nil) lastid=@"";
    if (theSearchBar.text==nil) theSearchBar.text=@"";
    queryString = [NSString stringWithFormat:@"&lastid=%@&keyword=%@", lastid, [[theSearchBar text] stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding]];
	queryData = [NSData dataWithBytes:[queryString UTF8String] length:[queryString length]];
    
    //	NSMutableURLRequest *urlRequest = [[NSMutableURLRequest alloc] initWithURL:[NSURL URLWithString: url]];
    NSMutableURLRequest *urlRequest = [NSMutableURLRequest requestWithURL:[NSURL URLWithString:url] cachePolicy:NSURLRequestUseProtocolCachePolicy timeoutInterval:20.0f];
	[urlRequest addValue: @"application/x-www-form-urlencoded; charset=utf-8;" forHTTPHeaderField:@"Content-Type"];
	[urlRequest addValue: [NSString stringWithFormat:@"%d", [queryData length]] forHTTPHeaderField:@"Content-Length"];
	[urlRequest setHTTPMethod:@"POST"];
	[urlRequest setHTTPBody: queryData];
	
	NSLog(@"url: %@", url);
	NSLog(@"queryData: %@", [[[NSString alloc] initWithData:queryData encoding:NSUTF8StringEncoding] autorelease]);
	
    self.urlCon = [[NSURLConnection alloc] initWithRequest:urlRequest delegate:self];
    [UIApplication sharedApplication].networkActivityIndicatorVisible = YES;
	[url release];
    //	[urlRequest release];
    
}

#pragma mark -
#pragma mark NSURLConnection delegate methods

- (void)connection:(NSURLConnection *)connection didReceiveResponse:(NSURLResponse *)response {
	self.rawData = [NSMutableData data];
    //Coolkie///////////////////////////
	NSURL *cookieUrl = [NSURL URLWithString:[[response URL] host]];
	NSHTTPURLResponse *urlResponse = (NSHTTPURLResponse *)response;
    NSArray *allCookies = [NSHTTPCookie cookiesWithResponseHeaderFields:[urlResponse allHeaderFields] forURL:cookieUrl];
	NSLog(@"%s [%d]: [allCookies count]: %d", __PRETTY_FUNCTION__, __LINE__, [allCookies count]);
    if ([allCookies count]) {
        [[NSHTTPCookieStorage sharedHTTPCookieStorage] setCookies:allCookies forURL:cookieUrl mainDocumentURL:nil];
	}
	//Coolkie///////////////////////////
}

- (void)connection:(NSURLConnection *)connection didReceiveData:(NSData *)data {
    [self.rawData appendData:data];
}

- (void)connection:(NSURLConnection *)connection didFailWithError:(NSError *)error {
    [UIApplication sharedApplication].networkActivityIndicatorVisible = NO;
    if ([error code] == kCFURLErrorNotConnectedToInternet) {
        NSDictionary *userInfo = [NSDictionary dictionaryWithObject:@"No Connection Error" forKey:NSLocalizedDescriptionKey];
        NSError *noConnectionError = [NSError errorWithDomain:NSCocoaErrorDomain code:kCFURLErrorNotConnectedToInternet userInfo:userInfo];
        [self handleError:noConnectionError];
    } else {
        [self handleError:error];
    }
    
    //Codes for Leak .... 
    [connection release];
    NSURLCache *sharedCache = [[NSURLCache alloc] initWithMemoryCapacity:0 diskCapacity:0 diskPath:nil];
    [NSURLCache setSharedURLCache:sharedCache];
    [sharedCache release];
}

- (void)connectionDidFinishLoading:(NSURLConnection *)connection {
    //Codes for Leak .... 
    [connection release];
    NSURLCache *sharedCache = [[NSURLCache alloc] initWithMemoryCapacity:0 diskCapacity:0 diskPath:nil];
    [NSURLCache setSharedURLCache:sharedCache];
    [sharedCache release];
	
    [UIApplication sharedApplication].networkActivityIndicatorVisible = NO;   
    
	NSLog(@"rawData: %@", [[[NSString alloc] initWithData:rawData encoding:NSUTF8StringEncoding] autorelease]);
	
	NSMutableDictionary *xmlDic = [[NSMutableDictionary alloc] init];
	[xmlDic setObject:@"info" forKey:@"infoTag"];
	[xmlDic setObject:@"data" forKey:@"dataTag"];
    [xmlDic 
     setObject:[NSArray arrayWithObjects:@"result", @"totrec", @"msg", nil] 
     forKey:@"infoFields"];
    [xmlDic setObject:[NSArray arrayWithObjects:@"rowid", @"subject", @"writer", @"reg_id", @"reg_date", @"type", @"publish", @"cryptid", @"latitude", @"longitude", @"content", nil] forKey:@"dataFields"];
    
	OWLXMLParser *parser = [[OWLXMLParser alloc] initWithData:rawData delegate:self xmlInfo:xmlDic];
	[parser startParse];
	[parser release];
	[xmlDic release];
    
	self.rawData = nil;
}

- (NSCachedURLResponse *) connection:(NSURLConnection *)connection willCacheResponse:(NSCachedURLResponse *)cachedResponse {
    return nil;
}

- (void)handleError:(NSError *)error {
    NSString *errorMessage = [error localizedDescription];
    UIAlertView *alertView = [[UIAlertView alloc] initWithTitle:@"Cannot Connect to Server." message:errorMessage delegate:nil cancelButtonTitle:@"OK" otherButtonTitles:nil];
    [alertView show];
    [alertView release];
}


#pragma mark -
#pragma mark XMLParse handle methods

- (void)didFinishParsing:(NSMutableDictionary *) resultDic {
	[self performSelectorOnMainThread:@selector(handleLoadedApps:) withObject:resultDic waitUntilDone:NO];
}

- (void)parseErrorOccurred:(NSError *)error {
    [self performSelectorOnMainThread:@selector(handleError:) withObject:error waitUntilDone:NO];
}

- (void)handleLoadedApps:(NSMutableDictionary *)loadedDic {
	int result = [[[loadedDic objectForKey:@"info"] objectForKey:@"result"] intValue];
	if (result == 1) {
        [self initReports:loadedDic];
	}
}

#pragma mark -
#pragma mark NSManagedObjectContext

- (void) initReports:(NSMutableDictionary *) loadedDic {
    NSLog(@"%s [%d] start ===========>",__PRETTY_FUNCTION__, __LINE__ );
    
    int totrec = [[[loadedDic objectForKey:@"info"] objectForKey:@"totrec"] intValue];
    NSLog(@"%s [%d] totrec : %d",__PRETTY_FUNCTION__, __LINE__ , totrec);
    
    NSInteger sectionCount = [[fetchedResultsController sections] count];
	if (sectionCount == 0) sectionCount = 1;
    
    BOOL found = NO;
    for (int k=0;k<totrec;k++) {
        NSMutableDictionary *dataTmp = [[[loadedDic objectForKey:@"data"] objectAtIndex:k] copy];
        found = NO;
        
        for (int i=0;i<sectionCount;i++) {
            id <NSFetchedResultsSectionInfo> sectionInfo = [[fetchedResultsController sections] objectAtIndex:i];
            NSInteger numberOfRows = 0;
            numberOfRows = [sectionInfo numberOfObjects];
            NSLog(@"%s [%d] numberOfRows : %d",__PRETTY_FUNCTION__, __LINE__ , numberOfRows);
            for (int j=0;j<numberOfRows;j++) {
                if ([[NSNumber numberWithInt:[[dataTmp valueForKey:@"rowid"] intValue]] isEqualToNumber:[(Report *) [fetchedResultsController objectAtIndexPath:[NSIndexPath indexPathForRow:j inSection:i]] rowid]]) {
                    found = YES;
                }
                if (found) break;
            }//for j
            if (found) break;
        }//for i
        
        if (found==NO) {
            Report *newReport = (Report *) [NSEntityDescription insertNewObjectForEntityForName:@"Report" inManagedObjectContext:managedObjectContext];
            
            newReport.rowid = [self string2Number:[dataTmp objectForKey:@"rowid"]];
            newReport.writer = [dataTmp objectForKey:@"writer"];
            newReport.subject = [dataTmp objectForKey:@"subject"];
            newReport.content = [dataTmp objectForKey:@"content"];
            newReport.reg_date = [self getDateTimeFromString:[dataTmp objectForKey:@"reg_date"]];
            newReport.reg_id = [dataTmp objectForKey:@"reg_id"];
            newReport.type = [dataTmp objectForKey:@"type"];
            newReport.publish = [self string2Number:[dataTmp objectForKey:@"publish"]];
            newReport.cryptid = [dataTmp objectForKey:@"cryptid"];
            newReport.latitude = [dataTmp objectForKey:@"latitude"];
            newReport.longitude = [dataTmp objectForKey:@"longitude"];
            
            newReport.listImage = [UIImage imageWithData:[NSData dataWithContentsOfURL:[NSURL URLWithString:[NSString stringWithFormat:@"http://www.owllab.com/ios/smartreport_file.php?listimageid=%@",[dataTmp objectForKey:@"cryptid"]]]]];
            
            newReport.image = [NSEntityDescription insertNewObjectForEntityForName:@"Image" inManagedObjectContext:managedObjectContext];
            /*
            [newReport.image setValue:[UIImage imageWithData:[NSData dataWithContentsOfURL:[NSURL URLWithString:[NSString stringWithFormat:@"http://www.owllab.com/ios/smartreport_file.php?imageid=%@",[dataTmp objectForKey:@"cryptid"]]]]] forKey:@"image"];
            NSURL * movieUrl = [NSURL URLWithString:[NSString stringWithFormat:@"http://www.owllab.com/ios/smartreport_file.php?movieid=%@",[dataTmp objectForKey:@"cryptid"]]];
            NSData *movieData = [NSData dataWithContentsOfURL:movieUrl];
            if ([movieData length]>0) {
                NSString *moviePath = [NSString stringWithFormat:@"%@/%@.mov", NSTemporaryDirectory(), newReport.rowid];
                [movieData writeToFile:moviePath atomically:NO];
                UISaveVideoAtPathToSavedPhotosAlbum (moviePath, self, @selector(movie:didFinishSavingWithError: contextInfo:), nil);
                newReport.movie = moviePath;
            }
            */
        }
        
        NSError *error = nil;
        if (![managedObjectContext save:&error]) {
            NSLog(@"%s [%d] Unresolved error %@, %@",__PRETTY_FUNCTION__, __LINE__ , error, [error userInfo]);
            abort();
        }
        
        [dataTmp release];
    }

    NSLog(@"%s [%d] end ===========>",__PRETTY_FUNCTION__, __LINE__ );
    
}

- (void) movie:(NSString *) moviePath didFinishSavingWithError:(NSError *) error contextInfo:(void *) contextInfo {
    if (error==nil) {
        NSLog(@"%s [%d] Movie File Saved: %@",__PRETTY_FUNCTION__, __LINE__, moviePath);
    } else {
        NSLog(@"%s [%d] Movie File Saving Error: %@",__PRETTY_FUNCTION__, __LINE__, error);
    }
}

#pragma mark -
#pragma mark Delete All

- (void) deleteAllListed {
    
    NSInteger sectionCount = [[fetchedResultsController sections] count];
	if (sectionCount == 0) sectionCount = 1;
    for (int i=0;i<sectionCount;i++) {
        id <NSFetchedResultsSectionInfo> sectionInfo = [[fetchedResultsController sections] objectAtIndex:i];
        for (int j=0;j<[sectionInfo numberOfObjects];j++) {
            NSIndexPath *indexPath = [[NSIndexPath indexPathForRow:j inSection:i] autorelease];
            [managedObjectContext deleteObject:[fetchedResultsController  objectAtIndexPath:indexPath]];
        }
    }
    
    NSError *error;
    if (![managedObjectContext save:&error]) {
        NSLog(@"Unresolved error %@, %@", error, [error userInfo]);
        abort();
    }
}

#pragma mark -
#pragma mark Utils 

- (NSDate *) getDateTimeFromString:(NSString *) dateString {
	NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
	[dateFormatter setDateFormat:@"yyyy-MM-dd HH:mm:ss"];
	NSDate *theDate = [dateFormatter dateFromString:dateString];
	[dateFormatter release];
	return theDate;
}

- (NSNumber *) string2Number:(NSString *) str {
    NSNumberFormatter *f = [[NSNumberFormatter alloc] init];
    [f setNumberStyle:NSNumberFormatterDecimalStyle];
    NSNumber *theNumber = [f numberFromString:str];
    [f release];
	return theNumber;
}

#pragma mark -
#pragma mark View lifecycle

- (void)viewDidLoad {
    [super viewDidLoad];
    [self loadReports];
	[self addActionBtn];
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
	
	[UIView beginAnimations:nil context:NULL];
	[UIView setAnimationDuration:1.5];
	[UIView setAnimationBeginsFromCurrentState:YES];
	[UIView setAnimationTransition:UIViewAnimationTransitionCurlUp forView:self.navigationController.view cache:NO];
	[UIView commitAnimations];
}


- (void)viewDidAppear:(BOOL)animated {
    [super viewDidAppear:animated];
}


#pragma mark -
#pragma mark Memory management

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}

/*
 - (void)viewDidUnload {
 
 }
 */

- (void)dealloc {
	[fetchedResultsController release];
	[managedObjectContext release];
    
    [queryString release];
    [queryData release];
    [urlCon release];
    [rawData release];
    [dicData release];
    [lastid release];
    
    [super dealloc];
}

@end

