

#import "photoView.h"
#import "Report.h"

#define ZOOM_VIEW_TAG 100
#define ZOOM_STEP 1.5 

@interface photoView (UtilityMethods)
- (CGRect)zoomRectForScale:(float)scale withCenter:(CGPoint)center;
@end

@implementation photoView

@synthesize report;

/*
 - (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
 {
 self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
 if (self) {
 // Custom initialization
 }
 return self;
 }
 */


#pragma mark - View lifecycle

- (void)viewDidLoad {
    [super viewDidLoad];
    
    imageScrollView.bouncesZoom = YES; 
    imageScrollView.delegate = self;
    imageScrollView.clipsToBounds = YES;
    imageScrollView.contentSize = [imageView frame].size;
    
    [imageView setTag:ZOOM_VIEW_TAG];
    
    UITapGestureRecognizer *singleTap = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(handleSingleTap:)];  
    UITapGestureRecognizer *doubleTap = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(handleDoubleTap:)];  
    UITapGestureRecognizer *twoFingerTap = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(handleTwoFingerTap:)];  
    
    [doubleTap setNumberOfTapsRequired:2];  
    [twoFingerTap setNumberOfTouchesRequired:2];  
    
    [imageView addGestureRecognizer:singleTap];  
    [imageView addGestureRecognizer:doubleTap];  
    [imageView addGestureRecognizer:twoFingerTap];
    
    [singleTap release];  
    [doubleTap release];  
    [twoFingerTap release]; 
    
    float minimumScale = [imageScrollView frame].size.width  / [imageView frame].size.width;   
    imageScrollView.minimumZoomScale = minimumScale;  
    imageScrollView.zoomScale = minimumScale; 
}

- (void)viewWillAppear:(BOOL)animated {
    imageView.image = [report.image valueForKey:@"image"];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    //return (interfaceOrientation == UIInterfaceOrientationPortrait);
    return (interfaceOrientation != UIInterfaceOrientationPortraitUpsideDown);
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}

- (void)viewDidUnload {
    [imageView release];
    imageView = nil;
    [imageScrollView release];
    imageScrollView = nil;
    [super viewDidUnload];
}

- (void)dealloc {
    [imageView release];
    [imageScrollView release];
    [super dealloc];
}

#pragma mark UIScrollViewDelegate methods  

- (UIView *)viewForZoomingInScrollView:(UIScrollView *)scrollView {  
    return [imageScrollView viewWithTag:ZOOM_VIEW_TAG];
}  

- (void)scrollViewDidEndZooming:(UIScrollView *)scrollView withView:(UIView *)view atScale:(float)scale {
    [scrollView setZoomScale:scale+0.01 animated:NO];
    [scrollView setZoomScale:scale animated:NO];
}

#pragma mark TapDetectingImageViewDelegate methods  

- (void)handleSingleTap:(UIGestureRecognizer *)gestureRecognizer {  
    NSLog(@"%s [%d]", __PRETTY_FUNCTION__, __LINE__);
}  

- (void)handleDoubleTap:(UIGestureRecognizer *)gestureRecognizer {  
    NSLog(@"%s [%d]", __PRETTY_FUNCTION__, __LINE__);
    float newScale = [imageScrollView zoomScale] * ZOOM_STEP;  
    CGRect zoomRect = [self zoomRectForScale:newScale withCenter:[gestureRecognizer locationInView:gestureRecognizer.view]];  
    [imageScrollView zoomToRect:zoomRect animated:YES];  
}  

- (void)handleTwoFingerTap:(UIGestureRecognizer *)gestureRecognizer {  
    NSLog(@"%s [%d]", __PRETTY_FUNCTION__, __LINE__);
    float newScale = [imageScrollView zoomScale] / ZOOM_STEP;  
    CGRect zoomRect = [self zoomRectForScale:newScale withCenter:[gestureRecognizer locationInView:gestureRecognizer.view]];  
    [imageScrollView zoomToRect:zoomRect animated:YES];  
}  

#pragma mark Utility methods  

- (CGRect)zoomRectForScale:(float)scale withCenter:(CGPoint)center {  
    CGRect zoomRect;  
    zoomRect.size.height = [imageScrollView frame].size.height / scale;  
    zoomRect.size.width  = [imageScrollView frame].size.width  / scale;  
    zoomRect.origin.x    = center.x - (zoomRect.size.width  / 2.0);  
    zoomRect.origin.y    = center.y - (zoomRect.size.height / 2.0);  
    return zoomRect;  
}  

@end






