
#import "smartView.h"
#import "Report.h"
#import "typeView.h"
#import "photoView.h"

@interface smartView (PrivateMethods)
- (void)updatePhotoButton;
- (void)updateMovieButton;
@end

@implementation smartView

@synthesize report;
@synthesize myInfo;

#pragma mark -
#pragma mark Section define
#define TYPE_SECTION 0



#pragma mark -
#pragma mark Initialization

/*
 - (id)initWithStyle:(UITableViewStyle)style {
     // Override initWithStyle: if you create the controller programmatically and want to perform customization that is not appropriate for viewDidLoad.
     self = [super initWithStyle:style];
     if (self) {
        // Custom initialization.
     }
     return self;
 }
 */

#pragma mark -
#pragma mark View lifecycle

- (void)viewDidLoad {
    [super viewDidLoad];
    
	myInfo = [[NSMutableDictionary alloc] init];
	[self getCookies];
    
    if ([report.reg_id isEqualToString:[myInfo objectForKey:@"suserdb.userid"]]) {
        self.navigationItem.rightBarButtonItem = self.editButtonItem;
    }
    
    if (tableHeaderView == nil) {
        [[NSBundle mainBundle] loadNibNamed:@"smartViewHeader" owner:self options:nil];
        self.tableView.tableHeaderView = tableHeaderView;
        self.tableView.allowsSelectionDuringEditing = YES;
    }
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
	
	[photoButton setImage:report.listImage forState:UIControlStateNormal];
    [self updatePhotoButton];
    [self updateMovieButton];
    
	self.navigationItem.title = report.type;
    inputSubject.text = report.subject;    
    inputWriter.text = report.writer;   
    inputRegDate.text = [self getDateTime:report.reg_date];
	inputContent.text = report.content;  
    inputRowid.text = [report.rowid stringValue];
    if ([report.publish integerValue] == 1) [publishSwitch setOn:YES];
    else [publishSwitch setOn:NO];
    if ([[self.navigationItem title] length]<=0) self.navigationItem.title = @"Unsorted";
    [self.tableView reloadData]; 
}

- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    return (interfaceOrientation != UIInterfaceOrientationPortraitUpsideDown);
}

#pragma mark - Memory Management

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}

- (void)dealloc {
    [inputSubject release];
    [inputWriter release];
    [inputRegDate release];
    [inputRowid release];
    [photoButton release];
    [movieButton release];
    [publishSwitch release];
    [inputContent release];
    [tableHeaderView release];

    [report release];
	[myInfo release];
    
    [super dealloc];
}

- (void)viewDidUnload {
    [inputSubject release];
    inputSubject = nil;
    [inputWriter release];
    inputWriter = nil;
    [inputRegDate release];
    inputRegDate = nil;
    [inputRowid release];
    inputRowid = nil;
    [photoButton release];
    photoButton = nil;
    [movieButton release];
    movieButton = nil;
    [publishSwitch release];
    publishSwitch = nil;
    [inputContent release];
    inputContent = nil;
    [tableHeaderView release];
    tableHeaderView = nil;
    [super viewDidUnload];
    // Release any retained subviews of the main view.
    // e.g. self.myOutlet = nil;
}


#pragma mark - Table view data source

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 2;
}

- (NSString *)tableView:(UITableView *)tableView titleForHeaderInSection:(NSInteger)section {
    NSString *title = nil;
    switch (section) {
        case TYPE_SECTION:
            title = @"Category";
            break;
        default:
            break;
    }
    return title;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    NSInteger rows = 0;
    switch (section) {
        case TYPE_SECTION:
            rows = 1;
            break;
		default:
            break;
    }
    return rows;
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    UITableViewCell *cell = nil;
	static NSString *CellIdentifier = @"CellIdentifier";	
    cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil) {
        cell = [[[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:CellIdentifier] autorelease];
        cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
    }
    NSString *text = nil;
    switch (indexPath.section) {
        case TYPE_SECTION:
            text = report.type;
            cell.accessoryType = UITableViewCellAccessoryNone;
            cell.editingAccessoryType = UITableViewCellAccessoryDisclosureIndicator;
            break;
        default:
            break;
    }
    cell.textLabel.text = text;
    return cell;
}


/*
// Override to support conditional editing of the table view.
- (BOOL)tableView:(UITableView *)tableView canEditRowAtIndexPath:(NSIndexPath *)indexPath
{
    // Return NO if you do not want the specified item to be editable.
    return YES;
}
*/

/*
// Override to support editing the table view.
- (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (editingStyle == UITableViewCellEditingStyleDelete) {
        // Delete the row from the data source
        [tableView deleteRowsAtIndexPaths:[NSArray arrayWithObject:indexPath] withRowAnimation:UITableViewRowAnimationFade];
    }   
    else if (editingStyle == UITableViewCellEditingStyleInsert) {
        // Create a new instance of the appropriate class, insert it into the array, and add a new row to the table view
    }   
}
*/

/*
// Override to support rearranging the table view.
- (void)tableView:(UITableView *)tableView moveRowAtIndexPath:(NSIndexPath *)fromIndexPath toIndexPath:(NSIndexPath *)toIndexPath
{
}
*/

/*
// Override to support conditional rearranging of the table view.
- (BOOL)tableView:(UITableView *)tableView canMoveRowAtIndexPath:(NSIndexPath *)indexPath
{
    // Return NO if you do not want the item to be re-orderable.
    return YES;
}
*/

#pragma mark - Table view delegate

- (NSIndexPath *)tableView:(UITableView *)tableView willSelectRowAtIndexPath:(NSIndexPath *)indexPath {
	NSIndexPath *rowToSelect = indexPath;
    NSInteger section = indexPath.section;
    BOOL isEditing = self.editing;
    if (isEditing && section == TYPE_SECTION) { } else  {
        [tableView deselectRowAtIndexPath:indexPath animated:YES];
        rowToSelect = nil;    
    }
	return rowToSelect;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    
    NSInteger section = indexPath.section;
    UIViewController *nextViewController = nil;
	
    switch (section) {
        case TYPE_SECTION:
            nextViewController = [[typeView alloc] initWithStyle:UITableViewStyleGrouped];
            ((typeView *)nextViewController).report = report;
            break;
        default:
            break;
    }
    
    if (nextViewController) {
        [self.navigationController pushViewController:nextViewController animated:YES];
        [nextViewController release];
    }
}


- (UITableViewCellEditingStyle)tableView:(UITableView *)tableView editingStyleForRowAtIndexPath:(NSIndexPath *)indexPath {
	UITableViewCellEditingStyle style = UITableViewCellEditingStyleNone;
    
    return style;
}


- (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath {
    
}

#pragma mark - Editing

- (void)setEditing:(BOOL)editing animated:(BOOL)animated {
    
    [super setEditing:editing animated:animated];
    
	[self updatePhotoButton];
    [self updateMovieButton];
    
	inputSubject.enabled = editing;
	inputWriter.enabled = NO;
	inputRegDate.enabled = NO;
	inputContent.editable = editing;
    publishSwitch.enabled = editing;
	[self.navigationItem setHidesBackButton:editing animated:YES];
	
	if (!editing) {
		report.local_state = @"[Modified] ";
        NSManagedObjectContext *context = report.managedObjectContext;
		NSError *error = nil;
		if (![context save:&error]) {
			NSLog(@"Unresolved error %@, %@", error, [error userInfo]);
			abort();
		}
        /*
         [self uploadData];
         */
    }
}


#pragma mark - UITextView UITextField Delegate

- (void)textViewDidEndEditing:(UITextView *)textView {
	if (textView == inputContent) {
		report.content = inputContent.text;
	}
}

- (BOOL)textFieldShouldEndEditing:(UITextField *)textField {
	if (textField == inputSubject) {
		report.subject = inputSubject.text;
	}
	return YES;
}


- (BOOL)textFieldShouldReturn:(UITextField *)textField {
	[textField resignFirstResponder];
	return YES;
}


#pragma mark -
#pragma mark NSHTTPCookieStorage Utils

- (void) getCookies {
	[myInfo removeAllObjects];
	NSArray *cookiea = [[NSHTTPCookieStorage sharedHTTPCookieStorage] cookies];
	for (int c=0; c<[cookiea count]; c++) {
		[myInfo setObject:[[cookiea objectAtIndex:c] value] forKey:[[cookiea objectAtIndex:c] name]];
		NSLog(@"%s [%d]: %@: %@", __PRETTY_FUNCTION__, __LINE__, [[cookiea objectAtIndex:c] name], [[cookiea objectAtIndex:c] value]);
	}
}

- (NSString *) getDateTime:(NSDate *) theDate {
	NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
	[dateFormatter setDateFormat:@"yyyy-MM-dd HH:mm:ss"];
	NSString *strDate = [dateFormatter stringFromDate:theDate];
	[dateFormatter release];
	return strDate;
}


#pragma mark - Photo

- (IBAction)selectPhoto:(id)sender {
    if (self.editing) {
		UIImagePickerController *imagePicker = [[UIImagePickerController alloc] init];
        imagePicker.sourceType = UIImagePickerControllerSourceTypePhotoLibrary;
		imagePicker.delegate = self;
        imagePicker.allowsEditing = YES;
		[self presentModalViewController:imagePicker animated:YES];
		[imagePicker release];
	} else {
        if (report.listImage!=nil && report.cryptid!=nil
            && [report.image valueForKey:@"image"]==nil) {
            [report.image setValue:[UIImage imageWithData:[NSData dataWithContentsOfURL:[NSURL URLWithString:[NSString stringWithFormat:@"http://www.owllab.com/ios/smartreport_file.php?imageid=%@",report.cryptid]]]] forKey:@"image"];
            NSManagedObjectContext *context = report.managedObjectContext;
            NSError *error = nil;
            if (![context save:&error]) {
                NSLog(@"Unresolved error %@, %@", error, [error userInfo]);
                abort();
            }           
        }
        
        photoView *photoViewTmp = [[photoView alloc] initWithNibName:@"photoView" bundle:nil];
                photoViewTmp.hidesBottomBarWhenPushed = YES;
        photoViewTmp.title = report.subject;
		photoViewTmp.report = report;
		[self.navigationController pushViewController:photoViewTmp animated:YES];
		[photoViewTmp release];
	}
}

- (void) updatePhotoButton {
	BOOL editing = self.editing;
	if (report.listImage != nil) {
		photoButton.highlighted = editing;
	} else {
		photoButton.enabled = editing;
		if (editing) {
			[photoButton setImage:[UIImage imageNamed:@"photo.png"] forState:UIControlStateNormal];
		} else {
			[photoButton setImage:nil forState:UIControlStateNormal];
		}
	}
}


#pragma mark -
#pragma mark UIImagePickerControllerDelegate Protocol

- (void) imagePickerController:(UIImagePickerController *)picker didFinishPickingMediaWithInfo:(NSDictionary *)info {
    NSLog(@"%s [%d]: start..............", __PRETTY_FUNCTION__, __LINE__);
    NSString* mediaType = [info objectForKey:UIImagePickerControllerMediaType];  
    if ( [mediaType isEqualToString:@"public.image" ]) {    
        UIImage* selectedImage = [info objectForKey:UIImagePickerControllerEditedImage];
        NSManagedObject *oldImage = report.image;
        if (oldImage != nil) {
            [report.managedObjectContext deleteObject:oldImage];
        }
        NSManagedObject *image = [NSEntityDescription insertNewObjectForEntityForName:@"Image" inManagedObjectContext:report.managedObjectContext];
        report.image = image;
        [image setValue:selectedImage forKey:@"image"];
        CGSize size = selectedImage.size;
        CGFloat ratio = 0;
        if (size.width > size.height) ratio = 64.0 / size.width;
        else ratio = 64.0 / size.height;
        CGRect rect = CGRectMake(0.0, 0.0, ratio * size.width, ratio * size.height);
        UIGraphicsBeginImageContext(rect.size);
        [selectedImage drawInRect:rect];
        report.listImage = UIGraphicsGetImageFromCurrentImageContext();
        UIGraphicsEndImageContext();
        [self updatePhotoButton];
    } else if ( [ mediaType isEqualToString:@"public.movie" ]){
        NSURL *videoURL =  [info objectForKey:UIImagePickerControllerMediaURL];
        NSLog(@"%s [%d]: videoURL: %@", __PRETTY_FUNCTION__, __LINE__, videoURL);
        NSLog(@"%s [%d]: [videoURL absoluteString]: %@", __PRETTY_FUNCTION__, __LINE__, [videoURL absoluteString]);
        report.movie = [NSString stringWithFormat:@"%@", videoURL];
        [self updateMovieButton];
    }
    //    [mediaType release];
    [self dismissModalViewControllerAnimated:YES];
    NSLog(@"%s [%d]: end..............", __PRETTY_FUNCTION__, __LINE__);
}

//– imagePickerController:didFinishPickingImage:editingInfo: Deprecated in iOS 3.0
/*
 - (void)imagePickerController:(UIImagePickerController *)picker didFinishPickingImage:(UIImage *)selectedImage editingInfo:(NSDictionary *)editingInfo {
 
 NSManagedObject *oldImage = report.image;
 if (oldImage != nil) {
 [report.managedObjectContext deleteObject:oldImage];
 }
 
 NSManagedObject *image = [NSEntityDescription insertNewObjectForEntityForName:@"Image" inManagedObjectContext:report.managedObjectContext];
 report.image = image;
 
 [image setValue:selectedImage forKey:@"image"];
 
 CGSize size = selectedImage.size;
 CGFloat ratio = 0;
 if (size.width > size.height) {
 ratio = 44.0 / size.width;
 } else {
 ratio = 44.0 / size.height;
 }
 CGRect rect = CGRectMake(0.0, 0.0, ratio * size.width, ratio * size.height);
 
 UIGraphicsBeginImageContext(rect.size);
 [selectedImage drawInRect:rect];
 report.listImage = UIGraphicsGetImageFromCurrentImageContext();
 UIGraphicsEndImageContext();
 
 [self dismissModalViewControllerAnimated:YES];
 }
 */

- (void)imagePickerControllerDidCancel:(UIImagePickerController *)picker {
    [self dismissModalViewControllerAnimated:YES];
}


#pragma mark - Movie
- (IBAction)selectMovie:(id)sender {
}

- (void) updateMovieButton {
	BOOL editing = self.editing;
	if (report.movie != nil) {
		movieButton.highlighted = editing;
        movieButton.alpha = 1.0;
	} else {
        movieButton.enabled = editing;
		if (editing) {
			[movieButton setImage:[UIImage imageNamed:@"film.png"] forState:UIControlStateNormal];
            movieButton.alpha = 1.0;
		} else {
			[movieButton setImage:nil forState:UIControlStateNormal];
            movieButton.alpha = 0.0;
		}
	}
}

#pragma mark - Switch Publishing

- (IBAction)setPublish:(id)sender {
    if (publishSwitch.on) {
        report.publish = [NSNumber numberWithInt:1];
    } else {
        report.publish = [NSNumber numberWithInt:0];
    }
}



@end
