
#import "noticeLocal.h"
#import "notice.h"
#import "noticeDetail.h"
#import "noticeList.h"
#import "noticeDB.h" //SQLite


@implementation noticeLocal

@synthesize listContent, filteredListContent, savedSearchTerm, savedScopeButtonIndex, searchWasActive;

#pragma mark -
#pragma mark View lifecycle

- (void)viewDidLoad {
	[UIView beginAnimations:nil context:NULL];
	[UIView setAnimationDuration:0.5];
	[UIView setAnimationBeginsFromCurrentState:YES];
	[UIView setAnimationTransition:UIViewAnimationTransitionCurlUp forView:self.navigationController.view cache:NO];
	[UIView commitAnimations];
	
	self.title = @"Notice(Local)";
	self.listContent = selectNoticeDB();
	self.filteredListContent = [NSMutableArray arrayWithCapacity:[self.listContent count]];
    if (self.savedSearchTerm) {
        [self.searchDisplayController setActive:self.searchWasActive];
        [self.searchDisplayController.searchBar setSelectedScopeButtonIndex:self.savedScopeButtonIndex];
        [self.searchDisplayController.searchBar setText:savedSearchTerm];
        self.savedSearchTerm = nil;
    }
	
	[self.tableView reloadData];
	self.tableView.scrollEnabled = YES;
	
	/* Manage Table Data with Context Menu */
	[self addActionBtn];
	 
}

- (void)viewDidUnload {
	self.filteredListContent = nil;
}

- (void)viewDidDisappear:(BOOL)animated {
    self.searchWasActive = [self.searchDisplayController isActive];
    self.savedSearchTerm = [self.searchDisplayController.searchBar text];
    self.savedScopeButtonIndex = [self.searchDisplayController.searchBar selectedScopeButtonIndex];
}


#pragma mark -
#pragma mark Table view data source
/*
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    // Return the number of sections.
    return 1;
}


- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
	if (tableView == self.searchDisplayController.searchResultsTableView) {
        return [self.filteredListContent count];
    } else {
        return [self.listContent count];
    }
}

- (NSString *)tableView:(UITableView *)tableView titleForHeaderInSection:(NSInteger)section {
	return [NSString stringWithFormat:@"%d Page", section+1];
}

// Customize the appearance of table view cells.
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    
    static NSString *CellIdentifier = @"Cell";
    
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil) {
        cell = [[[UITableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:CellIdentifier] autorelease];
		cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
    }
    
    notice *noticeRow = nil;
	if (tableView == self.searchDisplayController.searchResultsTableView) {
        noticeRow = [self.filteredListContent objectAtIndex:indexPath.row];
    } else {
        noticeRow = [self.listContent objectAtIndex:indexPath.row];
    }
	
	cell.textLabel.text = noticeRow.subject;
	cell.detailTextLabel.text = noticeRow.reg_date;
	
	return cell;
}
 */


#pragma mark -
#pragma mark Table view delegate

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
	
	noticeDetail *detailViewController = [[noticeDetail alloc] initWithNibName:@"noticeDetail" bundle:nil];
	
	notice *noticeRow = nil;
	if (tableView == self.searchDisplayController.searchResultsTableView) {
        noticeRow = [self.filteredListContent objectAtIndex:indexPath.row];
    } else {
        noticeRow = [self.listContent objectAtIndex:indexPath.row];
    }
	
	detailViewController.title = [NSString stringWithFormat:@"%@. %@", noticeRow.rowid, noticeRow.subject];
	detailViewController.viewData = noticeRow;
	[self.navigationController pushViewController:detailViewController animated:YES];
}


#pragma mark -
#pragma mark Memory management

- (void)didReceiveMemoryWarning {
    // Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
    
    // Relinquish ownership any cached data, images, etc. that aren't in use.
}

- (void)dealloc {
	[listContent release];
	[filteredListContent release];
	
    [super dealloc];
}

#pragma mark -
#pragma mark Content Filtering

- (void)filterContentForSearchText:(NSString*)searchText scope:(NSString*)scope {
	
	[self.filteredListContent removeAllObjects];
	
	for (notice *noticeTmp in listContent) {
		NSComparisonResult result;
		if ([scope isEqualToString:@"일자"]) {
			result = [noticeTmp.reg_date compare:searchText options:(NSCaseInsensitiveSearch|NSDiacriticInsensitiveSearch) range:NSMakeRange(0, [searchText length])];
		} else { 
			result = [noticeTmp.subject compare:searchText options:(NSCaseInsensitiveSearch|NSDiacriticInsensitiveSearch) range:NSMakeRange(0, [searchText length])];
		}
		
		if (result == NSOrderedSame) {
			[self.filteredListContent addObject:noticeTmp];
		}
	}
}


#pragma mark -
#pragma mark UISearchDisplayController Delegate Methods

- (BOOL)searchDisplayController:(UISearchDisplayController *)controller shouldReloadTableForSearchString:(NSString *)searchString {
    [self filterContentForSearchText:searchString scope:
	 [[self.searchDisplayController.searchBar scopeButtonTitles] objectAtIndex:[self.searchDisplayController.searchBar selectedScopeButtonIndex]]];
    return YES;
}


- (BOOL)searchDisplayController:(UISearchDisplayController *)controller shouldReloadTableForSearchScope:(NSInteger)searchOption {
    [self filterContentForSearchText:[self.searchDisplayController.searchBar text] scope:
	 [[self.searchDisplayController.searchBar scopeButtonTitles] objectAtIndex:searchOption]];
    return YES;
}

/* Manage Table Data with Context Menu */

#pragma mark -
#pragma mark Context Menu

- (void) addActionBtn {
	UIBarButtonItem *addButton = [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemAction  target:self action:@selector(contextMenu:)];
    [self.navigationItem setRightBarButtonItem:addButton];
	[addButton release];
}

enum ArchiveActionSheetButtons {
	DeleteAll,
	Delete
};

- (IBAction) contextMenu:(id)sender {
	UIActionSheet *sheet = [[[UIActionSheet alloc] initWithTitle:nil delegate:nil cancelButtonTitle:nil destructiveButtonTitle:nil otherButtonTitles:nil] autorelease];
	[sheet addButtonWithTitle:@"Delete All Local Data"];
	[sheet addButtonWithTitle:@"Delete Individually"];
	[sheet addButtonWithTitle:@"Cancel"];
	sheet.cancelButtonIndex = 2;
	sheet.delegate = self;
	[sheet showInView:self.view];
}

- (void) actionSheet:(UIActionSheet*)actionSheet clickedButtonAtIndex:(NSInteger)buttonIndex {
	switch(buttonIndex) {
		case DeleteAll: {
			deleteNoticeDB();
			listContent = selectNoticeDB();
			break;
		}	
		case Delete: {
			[self EditTable];
			break;
		}
	}
	[self.tableView reloadData];
}

#pragma mark -
#pragma mark EditTable 

- (void) EditTable {
	
    if(self.tableView.editing) {
		[super setEditing:NO animated:NO];
		[self.tableView setEditing:NO animated:NO];
		[self.tableView reloadData];
//        [self.navigationItem.leftBarButtonItem setTitle:@"Edit"];
//        [self.navigationItem.leftBarButtonItem setStyle:UIBarButtonItemStylePlain];
		
		[self.navigationItem setRightBarButtonItem:[[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemAction target:self action:@selector(contextMenu:)]];
    } else {
		[super setEditing:YES animated:YES];
		[self.tableView setEditing:YES animated:YES];
		[self.tableView reloadData];
//        [self.navigationItem.leftBarButtonItem setTitle:@"Done"];
//        [self.navigationItem.leftBarButtonItem setStyle:UIBarButtonItemStyleDone];
		
		[self.navigationItem setRightBarButtonItem:[[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemDone target:self action:@selector(EditTable)]];
    }
	
}


- (BOOL)tableView:(UITableView *)tableView canEditRowAtIndexPath:(NSIndexPath *)indexPath {
	return YES;
}

- (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath {
    
    if (editingStyle == UITableViewCellEditingStyleDelete) {
		notice *noticeTmp = [self.listContent objectAtIndex:indexPath.row];
		int rowid = [noticeTmp.rowid intValue];
		deleteRowNoticeDB(rowid);
		[listContent removeObjectAtIndex:indexPath.row];
		[self.tableView reloadData];
    }  else if (editingStyle == UITableViewCellEditingStyleInsert) {

    }   
	
}

#pragma mark -
#pragma mark Indexed TableView With Sections

static int ipp = 5;

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
	NSInteger r = 1;
	if (tableView == self.searchDisplayController.searchResultsTableView) {
        r = [self.filteredListContent count];
    } else {
        r = [self.listContent count];
    }
	return ceil (r*1.0 / ipp);
}


- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
	NSInteger theTotnum = [self.listContent count];
	if (tableView == self.searchDisplayController.searchResultsTableView) 
		theTotnum = [self.filteredListContent count];
	NSInteger theNum = theTotnum - (section) * ipp;
	if (theNum > ipp) theNum = ipp; 
	return theNum;
}

- (NSString *)tableView:(UITableView *)tableView titleForHeaderInSection:(NSInteger)section {
	return [NSString stringWithFormat:@"%d Page", section+1];
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    
    static NSString *CellIdentifier = @"Cell";
    
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil) {
        cell = [[[UITableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:CellIdentifier] autorelease];
		cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
    }
    
    notice *noticeRow = nil;
	NSInteger theRow = indexPath.section * ipp + indexPath.row;
	if (tableView == self.searchDisplayController.searchResultsTableView) {
        noticeRow = [self.filteredListContent objectAtIndex:theRow];
    } else {
        noticeRow = [self.listContent objectAtIndex:theRow];
    }
	
	cell.textLabel.text = [noticeRow.rowid  stringByAppendingFormat:@". %@", noticeRow.subject];
	cell.detailTextLabel.text = noticeRow.reg_date;
	
	return cell;
}


- (NSArray *)sectionIndexTitlesForTableView:(UITableView *)tableView {
	
	NSInteger theTotnum = [self.listContent count];
	if (tableView == self.searchDisplayController.searchResultsTableView) 
		theTotnum = [self.filteredListContent count];
	
	NSMutableArray *tempArray = [[[NSMutableArray alloc] init] autorelease];
	for (int i=0; i< theTotnum; i++) {
		notice *theRow = nil;
		if (tableView == self.searchDisplayController.searchResultsTableView) {
			theRow = [self.filteredListContent objectAtIndex:i];
		} else {
			theRow = [self.listContent objectAtIndex:i];
		}

		[tempArray addObject:theRow.rowid];
	}
	return tempArray;
}

- (NSInteger)tableView:(UITableView *)tableView sectionForSectionIndexTitle:(NSString *)title atIndex:(NSInteger)index {
	NSInteger theTotnum = [self.listContent count];
	if (tableView == self.searchDisplayController.searchResultsTableView) 
		theTotnum = [self.filteredListContent count];
	NSInteger thePage = floor(index*1.0 / ipp);
	return thePage;
}


@end

