
#import "ReportTableViewCell.h"

#pragma mark -
#pragma mark SubviewFrames category

@interface ReportTableViewCell (SubviewFrames)
- (CGRect)_imageViewFrame;
- (CGRect)_subjectLabelFrame;
- (CGRect)_briefLabelFrame;
- (CGRect)_regDateLabelFrame;
- (CGRect)_writerLabelFrame;
@end


#pragma mark -
#pragma mark ReportTableViewCell implementation

@implementation ReportTableViewCell

@synthesize report, imageView, subjectLabel, briefLabel, regDateLabel, type;
@synthesize writerLabel;


#pragma mark -
#pragma mark Initialization

- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier {
	
	if (self == [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        imageView = [[UIImageView alloc] initWithFrame:CGRectZero];
		imageView.contentMode = UIViewContentModeScaleAspectFit;
        [self.contentView addSubview:imageView];
		
        writerLabel = [[UILabel alloc] initWithFrame:CGRectZero];
        [writerLabel setTextAlignment:UITextAlignmentRight];
        [writerLabel setFont:[UIFont systemFontOfSize:12.0]];
        [writerLabel setTextColor:[UIColor darkGrayColor]];
        [writerLabel setHighlightedTextColor:[UIColor whiteColor]];
        [self.contentView addSubview:writerLabel];
        
        briefLabel = [[UILabel alloc] initWithFrame:CGRectZero];
        [briefLabel setFont:[UIFont systemFontOfSize:12.0]];
        [briefLabel setTextColor:[UIColor darkGrayColor]];
        [briefLabel setHighlightedTextColor:[UIColor whiteColor]];
        [self.contentView addSubview:briefLabel];
		
        regDateLabel = [[UILabel alloc] initWithFrame:CGRectZero];
        regDateLabel.textAlignment = UITextAlignmentRight;
        [regDateLabel setFont:[UIFont systemFontOfSize:12.0]];
        [regDateLabel setTextColor:[UIColor blackColor]];
        [regDateLabel setHighlightedTextColor:[UIColor whiteColor]];
		regDateLabel.minimumFontSize = 7.0;
		regDateLabel.lineBreakMode = UILineBreakModeTailTruncation;
        [self.contentView addSubview:regDateLabel];
		
        subjectLabel = [[UILabel alloc] initWithFrame:CGRectZero];
        [subjectLabel setFont:[UIFont boldSystemFontOfSize:14.0]];
        [subjectLabel setTextColor:[UIColor blackColor]];
        [subjectLabel setHighlightedTextColor:[UIColor whiteColor]];
        [self.contentView addSubview:subjectLabel];
    }
	
    return self;
}


#pragma mark -
#pragma mark Laying out subviews

- (void)layoutSubviews {
    [super layoutSubviews];
	
    [imageView setFrame:[self _imageViewFrame]];
    [subjectLabel setFrame:[self _subjectLabelFrame]];
    [briefLabel setFrame:[self _briefLabelFrame]];
    [regDateLabel setFrame:[self _regDateLabelFrame]];
    [writerLabel setFrame:[self _writerLabelFrame]];
    if (self.editing) {
        regDateLabel.alpha = 0.0;
    } else {
        regDateLabel.alpha = 1.0;
    }
}


#define IMAGE_SIZE          42.0
#define EDITING_INSET       10.0
#define TEXT_LEFT_MARGIN    8.0
#define TEXT_RIGHT_MARGIN   5.0
#define TEXT_RIGHT_WIDTH     80.0


- (CGRect)_imageViewFrame {
    if (self.editing) {
        return CGRectMake(EDITING_INSET, 0.0, IMAGE_SIZE, IMAGE_SIZE);
    } else {
        return CGRectMake(0.0, 0.0, IMAGE_SIZE, IMAGE_SIZE);
    }
}

- (CGRect)_subjectLabelFrame {
    if (self.editing) {
        return CGRectMake(IMAGE_SIZE + EDITING_INSET + TEXT_LEFT_MARGIN, 4.0, self.contentView.bounds.size.width - IMAGE_SIZE - EDITING_INSET - TEXT_LEFT_MARGIN, 16.0);
    } else {
        return CGRectMake(IMAGE_SIZE + TEXT_LEFT_MARGIN, 4.0, self.contentView.bounds.size.width - IMAGE_SIZE - TEXT_RIGHT_MARGIN * 2 - TEXT_RIGHT_WIDTH, 16.0);
    }
}

- (CGRect)_briefLabelFrame {
    if (self.editing) {
        return CGRectMake(IMAGE_SIZE + EDITING_INSET + TEXT_LEFT_MARGIN, 22.0, self.contentView.bounds.size.width - IMAGE_SIZE - EDITING_INSET - TEXT_LEFT_MARGIN, 16.0);
    } else {
        return CGRectMake(IMAGE_SIZE + TEXT_LEFT_MARGIN, 22.0, self.contentView.bounds.size.width - IMAGE_SIZE - TEXT_LEFT_MARGIN - TEXT_RIGHT_WIDTH, 16.0);
    }
}

- (CGRect)_regDateLabelFrame {
    CGRect contentViewBounds = self.contentView.bounds;
    return CGRectMake(contentViewBounds.size.width - TEXT_RIGHT_WIDTH - TEXT_RIGHT_MARGIN, 4.0, TEXT_RIGHT_WIDTH, 16.0);
}

- (CGRect)_writerLabelFrame {
    CGRect contentViewBounds = self.contentView.bounds;
    return CGRectMake(contentViewBounds.size.width - TEXT_RIGHT_WIDTH - TEXT_RIGHT_MARGIN, 22.0, TEXT_RIGHT_WIDTH, 16.0);
}


#pragma mark -
#pragma mark Report set accessor

- (void)setReport:(Report *)newReport {
    if(newReport != report) {
        [report release];
        report = [newReport retain];
	}
    
    NSString *publishIcon = @"[Local] ";
    if ([report.rowid longValue] > 0) {
        publishIcon = @"";
        if ([report.publish intValue] > 0) publishIcon = @"[Publish] "; 
    }
	imageView.image = report.listImage;
    subjectLabel.text = report.subject;
    if ([type isEqualToString:@"my"]) {
        if (report.local_state==nil) report.local_state = @"";
        if (report.content==nil) report.content = @"";
        briefLabel.text = [NSString stringWithFormat:@"%@%@%@",publishIcon, report.local_state, report.content];
    } else {
        briefLabel.text = report.content;
    }
	regDateLabel.text = [self getDateTime:report.reg_date];
    writerLabel.text = report.writer;
}

- (NSString *) getDateTime:(NSDate *) theDate {
	NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
	[dateFormatter setDateFormat:@"yyyy-MM-dd HH:mm:ss"];
	NSString *strDate = [dateFormatter stringFromDate:theDate];
	[dateFormatter release];
	return strDate;
}


#pragma mark -
#pragma mark Memory management

- (void)dealloc {
    [report release];
    [imageView release];
    [subjectLabel release];
    [briefLabel release];
    [writerLabel release];
    [regDateLabel release];
    [type release];
    [super dealloc];
}

@end