package com.owl.sample.cms;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.util.Log;

public class util {

	public Activity act;
	public String TAG = "util";
	
	public util() {

	}

	public util(Activity tmpact) {
		act = tmpact;
	}
	
	public void goActivity(Context mContext, String menuClass) {
		Class<?> cls;
		Activity actCategory;
		try {
			cls = Class.forName(menuClass);
			actCategory = (Activity) cls.newInstance();
			Intent intent = new Intent(mContext, actCategory.getClass());
			mContext.startActivity(intent);
		} catch (ClassNotFoundException e) {
			AlertDialog dialog = new AlertDialog.Builder(mContext).create();
			dialog.setTitle("안내");
			dialog.setMessage("죄송합니다.\n페이지를 찾을 수 없습니다.");
			dialog.setButton("확인", new DialogInterface.OnClickListener() {
				public void onClick(DialogInterface dialog, int which) {
					return;
				}
			});
			dialog.show();
		} catch (InstantiationException e) {

		} catch (IllegalAccessException e) {

		}
	}
	
	public void gotoSMS(String destinationAddress, String text) {
		Log.v(TAG, "gotoSMS:" + destinationAddress);
		if (act == null)
			return;
		Uri uri = Uri.parse("smsto:" + destinationAddress);
		Intent intent = new Intent(Intent.ACTION_SENDTO, uri);
		intent.putExtra("sms_body", text);
		act.startActivity(intent);
	}

	public void gotoTel(String destinationAddress) {
		Log.v(TAG, "gotoTel:" + destinationAddress);
		if (act == null)
			return;
		Uri uri = Uri.parse("tel:" + destinationAddress);
		Intent intent = new Intent(Intent.ACTION_DIAL, uri);
		act.startActivity(intent);
	}

	public void gotoEmail(String destinationAddress) {
		Log.v(TAG, "gotoEmail:" + destinationAddress);
		if (act == null)
			return;
		Uri uri = Uri.parse("mailto:" + destinationAddress);
		Intent intent = new Intent(Intent.ACTION_SENDTO, uri);
		act.startActivity(intent);
	}

	public void gotoWeb(String destinationAddress) {
		Log.v(TAG, "gotoWeb:" + destinationAddress);
		if (act == null)
			return;
		Uri uri = Uri.parse("http://" + destinationAddress);
		Intent intent = new Intent(Intent.ACTION_VIEW, uri);
		act.startActivity(intent);
	}
}
