package com.owl.sample;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.os.Bundle;
import android.view.ContextMenu;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ContextMenu.ContextMenuInfo;

public class MenuActivity extends Activity {

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        registerForContextMenu(this.findViewById(R.id.linearLayout1));
    }
    
    // optionMenu//////////////////////////	
	@Override
	public boolean onPrepareOptionsMenu(Menu menu) {
		new optionMenu(this).initMenu(menu);
		return super.onPrepareOptionsMenu(menu);
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		MenuInflater inflater = getMenuInflater();
		inflater.inflate(R.menu.option_menu, menu);
		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		boolean tmp = new optionMenu(this).initSelected(item);
		if (tmp)
			return tmp;
		else
			return super.onOptionsItemSelected(item);
	}
	// optionMenu//////////////////////////

	// context menu//////////////////////////
	@Override
	public void onCreateContextMenu(ContextMenu menu, View v,
			ContextMenuInfo menuInfo) {
		super.onCreateContextMenu(menu, v, menuInfo);
		MenuInflater inflater = getMenuInflater();
		inflater.inflate(R.menu.context_menu, menu);
	}

	Activity act = this;
	@Override
	public boolean onContextItemSelected(MenuItem item) {
		Intent intent;
		switch (item.getItemId()) {
		case R.id.goGallery:
			intent = new Intent(Intent.ACTION_RUN);
			intent.setComponent(new ComponentName(
					"com.cooliris.media",
					"com.cooliris.media.Gallery"));
			act.startActivity(intent);
			return true;
			
		case R.id.goCalc:
			intent = new Intent(Intent.ACTION_RUN);
			intent.setComponent(new ComponentName(
					"com.sec.android.app.calculator",
					"com.sec.android.app.calculator.Calculator"));
			act.startActivity(intent);
			return true;
			
		case R.id.goMusic:
			intent = new Intent(Intent.ACTION_RUN);
			intent.setComponent(new ComponentName(
					"com.android.music",
					"com.android.music.list.activity.MpMainTabActivity"));
			act.startActivity(intent);
			return true;
			
		default:
			return super.onContextItemSelected(item);
		}
	}
	// context menu//////////////////////////
}