package com.owl.sample;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.util.List;

import android.app.Activity;
import android.content.ContentValues;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.PixelFormat;
import android.hardware.Camera;
import android.hardware.Camera.AutoFocusCallback;
import android.hardware.Camera.CameraInfo;
import android.hardware.Camera.PictureCallback;
import android.hardware.Camera.ShutterCallback;
import android.os.Bundle;
import android.os.Environment;
import android.provider.MediaStore.Images;
import android.util.Log;
import android.view.Display;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.Toast;
import android.widget.ZoomControls;

public class ZoomControlsActivity extends Activity implements SurfaceHolder.Callback  {
	Activity act = this;
	SurfaceView surface;
	SurfaceHolder sHolder;
	ImageView iv;
	ZoomControls zc;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		// setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
		getWindow().setFormat(PixelFormat.TRANSLUCENT);
		requestWindowFeature(Window.FEATURE_NO_TITLE);
		getWindow().addFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN);
		setContentView(R.layout.main);

		iv = (ImageView) findViewById(R.id.imageView1);
		surface = (SurfaceView) findViewById(R.id.surfaceView1);
		sHolder = surface.getHolder();
		sHolder.addCallback(this);
		sHolder.setKeepScreenOn(true);
		sHolder.setType(SurfaceHolder.SURFACE_TYPE_PUSH_BUFFERS);

		findViewById(R.id.button1).setOnClickListener(
				new Button.OnClickListener() {
					public void onClick(View v) {
						_camera.startPreview();
					}
				});

		findViewById(R.id.button2).setOnClickListener(
				new Button.OnClickListener() {
					public void onClick(View v) {
						takePicture();
					}
				});

		zc = (ZoomControls) findViewById(R.id.zoomControls1);
		zc.setIsZoomInEnabled(true);
		zc.setIsZoomOutEnabled(true);
		zc.setZoomSpeed(10);
		zc.setOnZoomInClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				zoomInOut(+1);
			}
		});
		zc.setOnZoomOutClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				zoomInOut(-1);
			}
		});

	}

	int curZoom = 0;

	public void zoomInOut(int dup) {
		if (_camera != null) {
			Camera.Parameters p = _camera.getParameters();
			if (p.isZoomSupported()) {
				p.getMaxZoom();
				curZoom = curZoom + dup;
				if (curZoom > p.getMaxZoom()) {
					curZoom = p.getMaxZoom();
					zc.setIsZoomInEnabled(false);
				} else {
					zc.setIsZoomInEnabled(true);
				}
				if (curZoom < 0) {
					curZoom = 0;
					zc.setIsZoomOutEnabled(false);
				} else {
					zc.setIsZoomOutEnabled(true);
				}
				p.setZoom(curZoom);
				_camera.setParameters(p);
				_camera.autoFocus(autoFocusCallback);
			} else {
				Toast.makeText(act, "Camera Zoom not Supported" + p.getZoom(),
						Toast.LENGTH_LONG).show();
			}
		}
	}

	AutoFocusCallback autoFocusCallback = new AutoFocusCallback(){
        public void onAutoFocus(boolean success, Camera mCamera) {
            success = true;
            return;
        }
	};

	public int findCamera(int type) {
		// type : CameraInfo.CAMERA_FACING_FRONT, CameraInfo.CAMERA_FACING_BACK
		int cameraId = CameraInfo.CAMERA_FACING_BACK;
		CameraInfo cameraInfo = new CameraInfo();
		for (int i = 0; i < Camera.getNumberOfCameras(); i++) {
			Camera.getCameraInfo(i, cameraInfo);
			if (cameraInfo.facing == type) {
				cameraId = i;
				break;
			}
		}
		return cameraId;
	}

	Camera _camera;
	boolean camState = false;

	@Override
	public void surfaceChanged(SurfaceHolder holder, int format, int width,
			int height) {
	}

	@Override
	public void surfaceCreated(SurfaceHolder holder) {
		if (!camState) {
			try {
				_camera = Camera
						.open(findCamera(CameraInfo.CAMERA_FACING_BACK));
				Camera.Parameters p = _camera.getParameters();
				Display display = ((WindowManager) getSystemService(WINDOW_SERVICE))
						.getDefaultDisplay();
				if (display.getRotation() == Surface.ROTATION_0) {
					_camera.setDisplayOrientation(90);
				}
				List<String> focusModes = p.getSupportedFocusModes();
				if (focusModes.contains(Camera.Parameters.FOCUS_MODE_AUTO)) {
				    p.setFocusMode(Camera.Parameters.FOCUS_MODE_AUTO);
				} else {
					Toast.makeText(act, "FOCUS_MODE_AUTO not Supported",
							Toast.LENGTH_LONG).show();
				}
				_camera.setParameters(p);
				_camera.setPreviewDisplay(holder);
				_camera.startPreview();
				_camera.autoFocus(autoFocusCallback);
				camState = true;
			} catch (IOException e) {
				Log.d("CAMERA", e.getMessage());
			}
		}
	}

	@Override
	public void surfaceDestroyed(SurfaceHolder holder) {
		_camera.stopPreview();
		_camera.release();
		_camera = null;
		camState = false;
	}

	private void takePicture() {
		_camera.takePicture(shutterCallback, rawCallback, jpegCallback);
	}

	ShutterCallback shutterCallback = new ShutterCallback() {
		public void onShutter() {
			// TODO Do something when the shutter closes.
		}
	};

	PictureCallback rawCallback = new PictureCallback() {
		public void onPictureTaken(byte[] data, Camera camera) {
			// TODO Do something with the image RAW data.
		}
	};

	PictureCallback jpegCallback = new PictureCallback() {
		public void onPictureTaken(byte[] data, Camera camera) {
			if (camera != null) {
				Bitmap bm = BitmapFactory.decodeByteArray(data, 0, data.length);
				int width = bm.getWidth();
				int height = bm.getHeight();
				Matrix matrix = new Matrix();
//				matrix.setScale(-1, 1);
//				Bitmap rbm1 = Bitmap.createBitmap(bm, 0, 0, width, height,
//						matrix, true);
//				matrix = new Matrix();
				matrix.postRotate(90);
				Bitmap rbm = Bitmap.createBitmap(bm, 0, 0, width, height,
						matrix, true);
				iv.setImageBitmap(rbm);
				savePicture(rbm);
			}
		}
	};

	public void savePicture(Bitmap image) {
		String path = Environment.getExternalStorageDirectory().toString()
				+ "/DCIM/Camera/Mirror" + nowdate() + ".jpg";
		FileOutputStream fos;
		try {
			fos = new FileOutputStream(path);
			image.compress(Bitmap.CompressFormat.JPEG, 100, fos);
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}

		File savedFile = new File(path);

		ContentValues values = new ContentValues();
		values.put(Images.Media.DATA, savedFile.getAbsolutePath());
		values.put(Images.Media.TITLE, savedFile.getName());
		values.put(Images.Media.DISPLAY_NAME, savedFile.getName());
		values.put(Images.Media.BUCKET_ID, savedFile.getName());
		values.put(Images.Media.DESCRIPTION, savedFile.getName());

		FileNameMap fileNameMap = URLConnection.getFileNameMap();
		values.put(Images.Media.MIME_TYPE, fileNameMap.getContentTypeFor(path));

		act.getContentResolver().insert(Images.Media.EXTERNAL_CONTENT_URI,
				values);
	}

	public String nowdate() {
		java.util.Date date = new java.util.Date();
		String year = String.valueOf(date.getYear() + 1900);
		String month = int2code(date.getMonth() + 1);
		String day = int2code(date.getDate());
		String hour = int2code(date.getHours());
		String minute = int2code(date.getMinutes());
		String second = int2code(date.getSeconds());
		return year + month + day + hour + minute + second;
	}

	public String int2code(int val) {
		String str = "";
		if (val < 10) {
			str += String.valueOf("0" + val);
		} else {
			str += String.valueOf(val);
		}
		return str;
	}
}