package com.owl.sample;

import java.util.ArrayList;
import java.util.List;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Gallery;
import android.widget.ImageSwitcher;
import android.widget.ImageView;
import android.widget.ViewSwitcher;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.FrameLayout.LayoutParams;

public class ViewSwitcherActivity extends Activity implements
		ViewSwitcher.ViewFactory {

	private ViewSwitcher vs;
	List<Integer> galleryIda = new ArrayList<Integer>();
	int t = 0;
	int swNum = 0;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
		for (int i = 1; i < 100; i++) {
			int res = getResources().getIdentifier("p" + i, "drawable", getPackageName());
			if (res <= 0) break;
			galleryIda.add(getResources().getIdentifier("p" + i, "drawable", getPackageName()));
		}
		Gallery g = (Gallery) findViewById(R.id.gallery1);
		g.setAdapter(new galleryAdapter(this));
		g.setOnItemClickListener(new OnItemClickListener() {
			public void onItemClick(AdapterView<?> parent, View v, int position, long id) {
				if (swNum % 2 == 0) {
					((ImageView) vs.getChildAt(0)).setImageResource(galleryIda.get(t));
					((ImageView) vs.getChildAt(1)).setImageResource(galleryIda.get(position));
					vs.showNext();
				} else {
					((ImageView) vs.getChildAt(1)).setImageResource(galleryIda.get(t));
					((ImageView) vs.getChildAt(0)).setImageResource(galleryIda.get(position));
					vs.showPrevious();
				}
				t = position;
				swNum++;
			}
		});
		vs = (ViewSwitcher) findViewById(R.id.viewSwitcher1);
		vs.setFactory(this);
		((ImageView) vs.getChildAt(0)).setImageResource(galleryIda.get(0));
	}

	@Override
	public View makeView() {
		ImageView iv1 = new ImageView(this);
		iv1.setBackgroundColor(0xFF000000);
		iv1.setScaleType(ImageView.ScaleType.FIT_CENTER);
		iv1.setLayoutParams(new ImageSwitcher.LayoutParams(
				LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT));
		return iv1;
	}

	public class galleryAdapter extends BaseAdapter {
		private final Context mContext;
		LayoutInflater inflater;
		public galleryAdapter(Context c) {
			mContext = c;
			inflater = (LayoutInflater) mContext
					.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		}
		public int getCount() {
			return galleryIda.size();
		}
		public Object getItem(int position) {
			return position;
		}
		public long getItemId(int position) {
			return position;
		}
		public View getView(int position, View convertView, ViewGroup parent) {
			if (convertView == null) {
				convertView = inflater.inflate(R.layout.gallery_item, parent, false);
			}
			ImageView imageView = (ImageView) convertView
					.findViewById(R.id.imageView1);
			imageView.setImageResource(galleryIda.get(position));
			return convertView;
		}
	}
}