package com.owl.sample;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.view.ViewStub;
import android.widget.Button;
import android.widget.ImageView;

public class ViewStubActivity extends Activity {
	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		ViewStub stub = (ViewStub) findViewById(R.id.viewStub1);
		View inflated = stub.inflate();
		inflated.bringToFront();
		
		final ImageView iv = (ImageView) findViewById(R.id.panel).findViewById(R.id.imageView1);
		iv.setScaleType(ImageView.ScaleType.FIT_CENTER);
		iv.setVisibility(View.INVISIBLE);
		
		inflated.setOnClickListener(new Button.OnClickListener() {
			public void onClick(View v) {
				if (iv.isShown()) {
					iv.setVisibility(View.INVISIBLE);
				} else {
					iv.setVisibility(View.VISIBLE);
				}
			}
		});
		
	}
}