package com.owl.sample;

import android.app.Activity;
import android.graphics.PointF;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnTouchListener;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ViewAnimator;
import android.widget.FrameLayout.LayoutParams;

public class ViewAnimatorActivity extends Activity implements OnTouchListener {
	
	private ViewAnimator va;
	private Animation leftIn;
	private Animation leftOut;
	private Animation rightIn;
	private Animation rightOut;
	
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        
        va = (ViewAnimator) findViewById(R.id.viewAnimator1);
        
        for (int i = 4; i < 100; i++) {
        	int res = getResources().getIdentifier("p" + i, "drawable",
					this.getPackageName());
        	if (res<=0) break;
        	ImageView iv = new ImageView(this);
        	iv.setImageResource(res);
        	va.addView(iv,i-1);
		}

        va.setOnTouchListener(this);

        leftIn = AnimationUtils.loadAnimation(this,R.anim.left_in);
        leftOut = AnimationUtils.loadAnimation(this,R.anim.left_out);
        rightIn = AnimationUtils.loadAnimation(this,R.anim.right_in);
        rightOut = AnimationUtils.loadAnimation(this,R.anim.right_out);
        
        findViewById(R.id.button1).setOnClickListener(
				new Button.OnClickListener() {
					public void onClick(View v) {
						slideRight();
					}
				});

		findViewById(R.id.button2).setOnClickListener(
				new Button.OnClickListener() {
					public void onClick(View v) {
						slideLeft();
					}
				});
    }
    
    public void slideLeft() {
    	va.setInAnimation(leftIn);
        va.setOutAnimation(leftOut);
		va.showNext();
    }
    
    public void slideRight() {
    	va.setInAnimation(rightIn);
        va.setOutAnimation(rightOut);
        va.showPrevious();
    }

	PointF startPoint = new PointF();
	int gap = 0;
	int preGap = 0;
	
	@Override
	public boolean onTouch(View v, MotionEvent event) {
		LayoutParams par = (LayoutParams) v.getLayoutParams();
		switch (event.getAction() & MotionEvent.ACTION_MASK) {
		case MotionEvent.ACTION_DOWN:
			startPoint.set(event.getX(), event.getY());
			break;
		case MotionEvent.ACTION_UP:
			preGap = (int) (event.getX() - startPoint.x);
			if (Math.abs(preGap)>80) {
				if (preGap > 0) slideRight();
				else slideLeft();
			}
			gap = 0;
			break;
		case MotionEvent.ACTION_MOVE:
			preGap = (int) (event.getX() - startPoint.x);
			if (preGap >= 0)  {
				if (preGap >= gap) gap = preGap;
			} else {
				if (preGap <= gap) gap = preGap;
			}
			break;
		}
		par.rightMargin = gap * (-1);
		par.leftMargin = gap;
		v.setLayoutParams(par);
		return true;
	}
	
}