package com.owl.sample;

import android.app.Activity;
import android.os.Bundle;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.view.View.OnClickListener;
import android.widget.RelativeLayout;
import android.widget.TabHost;
import android.widget.TextView;
import android.widget.TabHost.TabSpec;

public class TabHostActivity extends Activity {

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		TabHost tabHost = (TabHost) findViewById(android.R.id.tabhost);
		tabHost.setup();

		TabSpec spec1 = tabHost.newTabSpec("Tab1");
		spec1.setContent(R.id.tab1);
		spec1.setIndicator(getString(R.string.tab1));
		// spec1.setIndicator(getString(R.string.tab1), getResources()
		// .getDrawable(R.drawable.cont1));
		tabHost.addTab(spec1);

		TabSpec spec2 = tabHost.newTabSpec("Tab2");
		spec2.setContent(R.id.tab2);
		spec2.setIndicator(getString(R.string.tab2));
		tabHost.addTab(spec2);

		TabSpec spec3 = tabHost.newTabSpec("Tab3").setContent(R.id.tab3)
				.setIndicator(getString(R.string.tab3));
		tabHost.addTab(spec3);

		// tabHost.setCurrentTab(0);

		tabHost.getTabWidget().getChildAt(0).getLayoutParams().height = 80;
		tabHost.getTabWidget().getChildAt(1).getLayoutParams().height = 80;
		tabHost.getTabWidget().getChildAt(2).getLayoutParams().height = 80;

		RelativeLayout.LayoutParams tvParams = new RelativeLayout.LayoutParams(
				ViewGroup.LayoutParams.MATCH_PARENT,
				ViewGroup.LayoutParams.WRAP_CONTENT);

		RelativeLayout rl1 = (RelativeLayout) tabHost.getTabWidget()
				.getChildAt(0);
		rl1.setGravity(Gravity.CENTER_VERTICAL);
		// rl1.getChildAt(0).getLayoutParams().height = 1;
		TextView tv1 = (TextView) rl1.getChildAt(1);
		tv1.setLayoutParams(tvParams);
		tv1.setTextAppearance(this, android.R.style.TextAppearance_Medium);
		tv1.setPadding(10, 0, 10, 0);
		tv1.setGravity(Gravity.CENTER);

		RelativeLayout rl2 = (RelativeLayout) tabHost.getTabWidget()
				.getChildAt(1);
		rl2.setGravity(Gravity.CENTER_VERTICAL);
		TextView tv2 = (TextView) rl2.getChildAt(1);
		tv2.setLayoutParams(tvParams);
		tv2.setTextAppearance(this, android.R.style.TextAppearance_Medium);
		tv2.setPadding(10, 0, 10, 0);
		tv2.setGravity(Gravity.CENTER);

		RelativeLayout rl3 = (RelativeLayout) tabHost.getTabWidget()
				.getChildAt(2);
		rl3.setGravity(Gravity.CENTER_VERTICAL);
		TextView tv3 = (TextView) rl3.getChildAt(1);
		tv3.setLayoutParams(tvParams);
		tv3.setTextAppearance(this, android.R.style.TextAppearance_Medium);
		tv3.setPadding(10, 0, 10, 0);
		tv3.setGravity(Gravity.CENTER);

		setTitle(getString(R.string.tab1));
		final Activity act = this;
		final TabHost tabHostCustom = tabHost;
		for (int i = 0; i < tabHost.getTabWidget().getChildCount(); i++) {
			final int a = i + 1;
			tabHostCustom.getTabWidget().getChildAt(i).setOnClickListener(
					new OnClickListener() {
						@Override
						public void onClick(View v) {
							act.setTitle(getString(getResources()
									.getIdentifier("tab" + a, "string",
											act.getPackageName())));
							tabHostCustom.setCurrentTab(a - 1);
						}
					});
		}
	}
}