package com.owl.sample;

import android.app.Activity;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.widget.TextView;

public class SensorGameActivity extends Activity implements SensorEventListener {
	private SensorManager mSensorManager;

	TextView tv1;
	TextView tv2;
	String logText = "";

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
		tv1 = (TextView) findViewById(R.id.textView1);
		tv2 = (TextView) findViewById(R.id.textView2);

		mSensorManager = (SensorManager) getSystemService(SENSOR_SERVICE);
	}

	protected void onResume() {
		super.onResume();
		
//		mSensorManager.registerListener(this, 
//				mSensorManager.getDefaultSensor(SensorManager.SENSOR_ACCELEROMETER),
//				SensorManager.SENSOR_DELAY_NORMAL);
//		mSensorManager.registerListener(this, 
//				mSensorManager.getDefaultSensor(SensorManager.SENSOR_MAGNETIC_FIELD),
//				SensorManager.SENSOR_DELAY_NORMAL);
//		mSensorManager.registerListener(this, 
//				mSensorManager.getDefaultSensor(SensorManager.SENSOR_ORIENTATION),
//				SensorManager.SENSOR_DELAY_NORMAL);
		
		mSensorManager.registerListener(this, 
				mSensorManager.getDefaultSensor(Sensor.TYPE_ACCELEROMETER),
				SensorManager.SENSOR_DELAY_NORMAL);
		mSensorManager.registerListener(this, 
				mSensorManager.getDefaultSensor(Sensor.TYPE_MAGNETIC_FIELD),
				SensorManager.SENSOR_DELAY_NORMAL);
		mSensorManager.registerListener(this, 
				mSensorManager.getDefaultSensor(Sensor.TYPE_ORIENTATION),
				SensorManager.SENSOR_DELAY_NORMAL);
		mSensorManager.registerListener(this, 
				mSensorManager.getDefaultSensor(Sensor.TYPE_PROXIMITY),
				SensorManager.SENSOR_DELAY_NORMAL);
		mSensorManager.registerListener(this, 
				mSensorManager.getDefaultSensor(Sensor.TYPE_TEMPERATURE),
				SensorManager.SENSOR_DELAY_NORMAL);
		mSensorManager.registerListener(this, 
				mSensorManager.getDefaultSensor(Sensor.TYPE_PRESSURE),
				SensorManager.SENSOR_DELAY_NORMAL);
		mSensorManager.registerListener(this, 
				mSensorManager.getDefaultSensor(Sensor.TYPE_GYROSCOPE),
				SensorManager.SENSOR_DELAY_NORMAL);
		mSensorManager.registerListener(this, 
				mSensorManager.getDefaultSensor(Sensor.TYPE_GRAVITY),
				SensorManager.SENSOR_DELAY_NORMAL);
		mSensorManager.registerListener(this, 
				mSensorManager.getDefaultSensor(Sensor.TYPE_LIGHT),
				SensorManager.SENSOR_DELAY_NORMAL);
		mSensorManager.registerListener(this, 
				mSensorManager.getDefaultSensor(Sensor.TYPE_LINEAR_ACCELERATION),
				SensorManager.SENSOR_DELAY_NORMAL);
		mSensorManager.registerListener(this, 
				mSensorManager.getDefaultSensor(Sensor.TYPE_ROTATION_VECTOR),
				SensorManager.SENSOR_DELAY_NORMAL);
		
//		mSensorManager.registerListener(this, 
//				mSensorManager.getDefaultSensor(Sensor.TYPE_ALL),
//				SensorManager.SENSOR_DELAY_NORMAL);
	}

	protected void onPause() {
		super.onPause();
		mSensorManager.unregisterListener(this);
	}

	public void onAccuracyChanged(Sensor sensor, int accuracy) {
		tv1.setText("onAccuracyChanged : " + sensor.getName() + "["
				+ sensor.getType() + "] " + accuracy);
	}

	public void onSensorChanged(SensorEvent event) {
		
		float[] values = event.values;
		
		if (logText.length()>10000) logText = "";
		if (logText.indexOf(event.sensor.getName())<0) {
			logText += "\n"+event.sensor.getName() 
				+ "["+event.sensor.getType()+"]";
		
			for (int v=0;v<values.length;v++) {
				if (v==0) logText += "\n";
				logText += " / " + v + " : " + values[v];
			}
		}
		
//		switch (event.sensor.getType()) {
//		case SensorManager.SENSOR_ACCELEROMETER:
//			logText += "\nAccelerometer: " + values[0] + ", " + values[1] + ", "
//			+ values[2];
//			break;
//		case SensorManager.SENSOR_MAGNETIC_FIELD:
//			logText += "\nCompass: " + values[0] + ", " + values[1] + ", "
//					+ values[2];
//			break;
//		case SensorManager.SENSOR_ORIENTATION:
//			logText += "\nOrientation: " + values[0] + ", " + values[1] + ", "
//					+ values[2];
//			break;
//		}
		
		tv2.setText(logText);
	}
}
