package com.owl.sample;

import java.io.IOException;
import java.io.InputStream;

import android.app.Activity;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.View;
import android.widget.ImageView;

public class ScrollViewActivity extends Activity {
	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		ImageView iv1 = (ImageView) findViewById(R.id.imageView1);
		ImageView iv2 = (ImageView) findViewById(R.id.imageView2);
		ImageView iv3 = (ImageView) findViewById(R.id.imageView3);
		ImageView iv4 = (ImageView) findViewById(R.id.imageView4);

		iv1.setAdjustViewBounds(true);
		iv1.setMaxWidth(400);
		iv1.setMaxHeight(400);

		iv2.setAdjustViewBounds(true);
		iv2.setMaxWidth(400);
		iv2.setMaxHeight(400);

		iv3.setAdjustViewBounds(true);
		iv3.setMaxWidth(400);
		iv3.setMaxHeight(400);

		iv4.setAdjustViewBounds(true);
		iv4.setMaxWidth(400);
		iv4.setMaxHeight(400);

		iv1.setImageDrawable(getResources().getDrawable(R.drawable.photo1));
		iv2.setImageDrawable(getResources().getDrawable(R.drawable.photo2));

		BitmapFactory.Options opts = new BitmapFactory.Options();
		opts.inScaled = true;
		opts.inDensity = DisplayMetrics.DENSITY_MEDIUM;
		Rect padding = new Rect();
		opts.inTargetDensity = getResources().getDisplayMetrics().densityDpi;
		Bitmap bm1;
		try {
			bm1 = BitmapFactory.decodeStream(getAssets().open("child1.JPG"),
					padding, opts);
			iv3.setImageBitmap(bm1);
		} catch (IOException e) {
			e.printStackTrace();
			iv3.setVisibility(View.INVISIBLE);
		}

		AssetManager assetManager = getAssets();
		InputStream inputStream;
		Bitmap bm2;
		try {
			inputStream = assetManager.open("child2.JPG");
			bm2 = BitmapFactory.decodeStream(inputStream);
			inputStream.close();
			iv4.setImageBitmap(bm2);
		} catch (IOException e) {
			e.printStackTrace();
			iv4.setVisibility(View.INVISIBLE);
		}

	}
}