package com.owl.sample;

import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Random;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Vibrator;
import android.view.View;

public class SQLiteActivity extends Activity {
    
	Activity act = this;
	
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
    }
    
    int ox = 0;
    int totalCount = 5; 
    int tryCount = 0;
    int wonCount = 0;
    String result = "실패";
    
    public void tryOX(View view) {
    	tryCount++;
    	ox = getLuckNum();
    	if (view.getId()==R.id.button1) {
    		if (ox==1) won();
    		else failed();
    	} else {
    		if (ox==2) won();
    		else failed();
    	}
    	showMSG();
    }
    
    public int getLuckNum() {
		Random random = new Random();
		int tmpi = random.nextInt(2)+1;
		return tmpi;
	}
    
    public void won() {
    	result = "성공";
    	wonCount++;
    }
    
    public void failed() {
    	Vibrator vb = (Vibrator) act.getSystemService(Context.VIBRATOR_SERVICE);
		vb.vibrate(2000);
		result = "실패";
    }
    
    public void showMSG() {
    	AlertDialog dialog = new AlertDialog.Builder(act).create();
    	if (totalCount>tryCount) {
    		dialog.setTitle(result+"했습니다.");
    		dialog.setMessage(wonCount+"번 성공했습니다.\n\n"
    				+totalCount+"번 중 "+(totalCount-tryCount)+"번 남았습니다.");
    	} else {
    		dialog.setTitle("당신의 성공확률은?");
    		dialog.setMessage("당신의 성공확율은 \n"
    				+wonPercent()+"% 입니다.");
    		tryCount = 0; wonCount = 0;
    	}
		dialog.setButton("확인", new DialogInterface.OnClickListener() {
			public void onClick(DialogInterface dialog, int which) {
				return;
			}
		});
		dialog.show();
    }
    
    public float wonPercent() {
    	float p = 0;
    	p = Math.round(wonCount*1.0f / totalCount*1.0f * 1000.0f) / 10.0f;
    	scoreIn(p);
    	return p;
	}
    
    public static final String uriString = "content://com.owl.sample.ContentProvider/score";
	public static final Uri CONTENT_URI = Uri.parse(uriString);

	public void scoreIn(float score) {
		SimpleDateFormat SDF = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
		ContentValues contVal = new ContentValues();
		contVal.put("name", SDF.format(new Date(System.currentTimeMillis())));
		contVal.put("score", score);
		ContentResolver cr = this.getContentResolver();
		cr.insert(CONTENT_URI, contVal);
	}
	
	public void gotoScoreBoard(View view) {
		Intent intent = new Intent(act, scoreActivity.class);
		act.startActivity(intent);
    }
}