package com.owl.sample;

import java.util.ArrayList;
import java.util.Random;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.graphics.Color;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.NumberPicker;
import android.widget.TextView;

public class NumberPickerActivity extends Activity {
   
	ArrayList<NumberPicker> tryObjs = new ArrayList<NumberPicker> ();
	ArrayList<Number> luckyNums = new ArrayList<Number> ();
	Number extrNum;
	int startNum = 1;
	int endNum = 45;
	int unitNum = 6;
	int wonNum = 0;
	int tryNum = 0;
	TextView winText;
	TextView tryedText;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        
        winText = (TextView) findViewById(R.id.textView3);
        tryedText = (TextView) findViewById(R.id.textView4);
        
        winText.setText("");
        tryedText.setText("");
        
        makeLottoResult();
        
        for (int i=1;i<=unitNum;i++) {
        	NumberPicker np = (NumberPicker) findViewById(
        			getResources().getIdentifier("numberPicker" + i, "id", getPackageName()));
        	np.setMinValue(startNum);
        	np.setMaxValue(endNum);
        	np.setValue(luckyNums.get(i-1).intValue());
        	tryObjs.add(np);
        }
        
        initStyle();
        
        findViewById(R.id.button1).setOnClickListener(new Button.OnClickListener() {
			public void onClick(View v) {
				tryLotto();
			}
		});
        
        findViewById(R.id.button2).setOnClickListener(new Button.OnClickListener() {
			public void onClick(View v) {
				suggestLottoNum();
			}
		});
        
        findViewById(R.id.button3).setOnClickListener(new Button.OnClickListener() {
			public void onClick(View v) {
				makeLottoResult();
			}
		});
    }
    
    public void initStyle() {
    	for (int i=0;i<tryObjs.size();i++) {
    		tryObjs.get(i).setBackgroundColor(0x000000);
    		tryObjs.get(i).clearFocus();
        }
	}
    
    public void makeLottoResult() {
    	luckyNums.clear();
    	Random random = new Random();
    	for (int i=0;i<=unitNum;i++) {
    		Number tmpi = random.nextInt(endNum) + 1;
    		while(luckyNums.contains(tmpi)) {tmpi = random.nextInt(endNum) + 1;} 
    		if (i<unitNum) luckyNums.add(tmpi);
    		else extrNum = random.nextInt(endNum) + 1;
    	}
    }
    public void suggestLottoNum() {
    	makeLottoResult();
    	printResult();
	}

    public void printResult() {
    	String resultMsg = "당첨번호 : ";
    	for (int i=0;i<luckyNums.size();i++) {
    		if (i>0) resultMsg += ", ";
    		resultMsg += luckyNums.get(i).toString();
    	}
    	resultMsg += " / 보너스번호 : " + extrNum.toString();
    	winText.setText(resultMsg);
    }
    
    public void tryLotto() {
    	initStyle();
    	if (luckyNums.size()<6) makeLottoResult();
    	tryNum++;
    	int matchNum = 0;
    	ArrayList<Number> myNums = new ArrayList<Number> ();
    	for (int i=0;i<tryObjs.size();i++) {
        	if (!myNums.contains(tryObjs.get(i).getValue()) 
        			&& luckyNums.contains(tryObjs.get(i).getValue())) {
        		tryObjs.get(i).setBackgroundColor(Color.GREEN);
        		matchNum++;
        	}
        	myNums.add(tryObjs.get(i).getValue());
        }
    	String msg = "";
    	if (matchNum==6) msg = "축하합니다.\n1등에 당첨됐습니다.\n6개의 번호를 모두 맞쳤습니다.";
    	else if (matchNum==5) {
    		if (myNums.contains(extrNum)) {
    			msg = "축하합니다.\n2등에 당첨됐습니다.\n5개의 번호와 보너스 번호를 맞쳤습니다.";
    		} else {
    			msg = "축하합니다.\n3등에 당첨됐습니다.\n5개의 번호와 보너스 번호를 맞쳤습니다.";
    		}
    	} else if (matchNum==4) msg = "축하합니다.\n4등에 당첨됐습니다.4개의 번호를 맞쳤습니다.";
    	else if (matchNum==3) msg = "축하합니다.\n5등에 당첨됐습니다.3개의 번호를 맞쳤습니다.";
    	if (matchNum>=3) wonNum++;
    	
    	if (!"".equals(msg)) showAlert(msg);
    	
    	String text = matchNum + "개의 번호를 맞췄습니다.";
    	text += "\n" + tryNum + "번 시도하여 "+wonNum+"번 담첨됐습니다.";
    	text += "\n당신의 당첨확률은 "+wonPercent()+"%입니다.";
    	tryedText.setText(text);
	}

    public float wonPercent() {
    	float p = 0;
    	p = Math.round(wonNum*1.0f / tryNum*1.0f * 1000.0f) / 10.0f;
    	return p;
	}

    public void showAlert(String msg) {
		AlertDialog dialog = new AlertDialog.Builder(this).create();
		dialog.setTitle("당첨안내");
		dialog.setMessage(msg);
		dialog.setButton("확인", new DialogInterface.OnClickListener() {
			public void onClick(DialogInterface dialog, int which) {
				return;
			}
		});
		dialog.show();
    }

}
    