package com.owl.sample;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;

import org.json.JSONException;
import org.json.JSONObject;

import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;

import com.google.android.maps.GeoPoint;
import com.google.android.maps.MapActivity;
import com.google.android.maps.MapController;
import com.google.android.maps.MapView;
import com.google.android.maps.Overlay;
import com.google.android.maps.OverlayItem;

public class MapSearchActivity extends MapActivity {
	
	MapView owlMap;
	public String TAG = "MapActivity";

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        final EditText mapAddress = (EditText) findViewById(R.id.mapAddress);
		Button mapSearchBtn = (Button) findViewById(R.id.mapSearchBtn);
		mapSearchBtn.setOnClickListener(new Button.OnClickListener() {
			public void onClick(View v) {
				String tmpKeyWord = mapAddress.getText().toString();
				doSearchMap(tmpKeyWord);
			}
		});
	    
	    owlMap = (MapView)findViewById(R.id.maps);
	    owlMap.setSatellite(true);
	    owlMap.setBuiltInZoomControls(true);
        GeoPoint p = new GeoPoint(37566535 , 126977969);
        MapController map = owlMap.getController();
        map.animateTo(p);
        map.setZoom(8);
    }
    
    public void doSearchMap(String query) {

		int latitude = 37566535;
		int longitude = 126977969;
		String encoding = "UTF-8";
		String queryEnc = "";
		
		try {
			queryEnc = URLEncoder.encode(query, encoding);
		} catch (UnsupportedEncodingException e) {
			Log.e(TAG, e.getMessage());
		}
		String theUrl = "http://maps.google.co.kr/maps/api/geocode/json?sensor=true&address="+queryEnc;
//		String theUrl = "http://maps.google.co.kr/maps/api/geocode/xml?sensor=true&address="+queryEnc;
		Log.i(TAG, theUrl);

		cmsHTTP cmsHttp = new cmsHTTP();
		cmsHttp.encoding = encoding;
		cmsHttp.act = this;
		String tmpData = cmsHttp.sendGet(theUrl);
		
		if (tmpData==null) return;
		
		Log.i(TAG, tmpData);
		
		try {
			JSONObject jObj = new JSONObject(tmpData);
			Log.i(TAG, jObj.toString());
			if (jObj!=null) {
				Log.i(TAG, "===========================");
				Log.i(TAG, jObj.getJSONArray("results").toString());
				Log.i(TAG, jObj.getJSONArray("results").getJSONObject(0).toString());
				Log.i(TAG, jObj.getJSONArray("results").getJSONObject(0).getString("geometry"));
				Log.i(TAG, jObj.getJSONArray("results").getJSONObject(0).getJSONObject("geometry")
						.getString("location"));
				Log.i(TAG, jObj.getJSONArray("results").getJSONObject(0).getJSONObject("geometry")
						.getJSONObject("location").getString("lat"));

				double tmpX = jObj.getJSONArray("results").getJSONObject(0).getJSONObject("geometry")
				.getJSONObject("location").getDouble("lat");
				double tmpY = jObj.getJSONArray("results").getJSONObject(0).getJSONObject("geometry")
				.getJSONObject("location").getDouble("lng");
				
				latitude = Double.valueOf(tmpX*1E6).intValue();
				longitude = Double.valueOf(tmpY*1E6).intValue();
				
				Log.i(TAG, "tmpX : "+Double.toString(tmpX));
				Log.i(TAG, "tmpY : "+Double.toString(tmpY));
				Log.i(TAG, "latitude : "+Integer.toString(latitude));
				Log.i(TAG, "longitude : "+Integer.toString(longitude));
			}
		} catch (JSONException e) {
			Log.e(TAG, e.getMessage());
		}
		viewMap(latitude, longitude, query);
	}
	
	
	public void viewMap(int latitude, int longitude, String query) {
		owlMap = (MapView)findViewById(R.id.maps);
	    owlMap.setSatellite(false);
	    owlMap.setBuiltInZoomControls(true);
	    
        GeoPoint p = new GeoPoint(latitude , longitude);
        List<Overlay> mapOverlays = owlMap.getOverlays();

        if (mapOverlays.size() > 0) {
        	mapOverlays.clear(); 
    		Log.d(TAG, "clear overlays : " + mapOverlays.size());
    	} else {
    		Log.d(TAG, "empty overlays");
    	}
        
        Drawable marker = this.getResources().getDrawable(R.drawable.map_mark);
        
    	marker.setBounds(0, 0, marker.getIntrinsicWidth(), marker.getIntrinsicHeight());       
        mapOverlay mapOverlay = new mapOverlay(marker);
        mapOverlay.mContext = this;
        mapOverlay.mPopulate();
        
        OverlayItem overlayitem = new OverlayItem(p, "목적지", query);
        mapOverlay.addOverlay(overlayitem);
        
        owlMap.getOverlays().add(mapOverlay);
        
        owlMap.getController().animateTo(p);
        owlMap.getController().setZoom(19);
        owlMap.postInvalidate();

	}

	@Override
	protected boolean isRouteDisplayed() {
		return false;
	}
}