package com.owl.sample;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentTransaction;
import android.app.ListFragment;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.ScrollView;
import android.widget.TextView;

public class FragmentActivity extends Activity {
	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
	}

	public static class DetailActivity extends Activity {
		@Override
		protected void onCreate(Bundle savedInstanceState) {
			super.onCreate(savedInstanceState);
			if (getResources().getConfiguration().orientation == Configuration.ORIENTATION_LANDSCAPE) {
				finish();
				return;
			}

			if (savedInstanceState == null) {
				DetailFragment detailView = new DetailFragment();
				detailView.setArguments(getIntent().getExtras());
				getFragmentManager().beginTransaction().add(
						android.R.id.content, detailView).commit();
			}
		}
	}

	public static class listFragment extends ListFragment {
		boolean detailState;
		int lastSelected = 0;

		@Override
		public void onActivityCreated(Bundle savedInstanceState) {
			super.onActivityCreated(savedInstanceState);

			String[] lista = getResources().getStringArray(R.array.list);

			setListAdapter(new ArrayAdapter<String>(getActivity(),
					android.R.layout.simple_list_item_activated_1, lista));

			View detailView = getActivity().findViewById(R.id.detailView);
			detailState = detailView != null
					&& detailView.getVisibility() == View.VISIBLE;

			if (savedInstanceState != null) {
				lastSelected = savedInstanceState.getInt("lastSelected", 0);
			}

			if (detailState) {
				getListView().setChoiceMode(ListView.CHOICE_MODE_SINGLE);
				loadDetail(lastSelected);
			}
		}

		@Override
		public void onSaveInstanceState(Bundle outState) {
			super.onSaveInstanceState(outState);
			outState.putInt("lastSelected", lastSelected);
		}

		@Override
		public void onListItemClick(ListView l, View v, int position, long id) {
			loadDetail(position);
		}

		void loadDetail(int index) {
			lastSelected = index;

			if (detailState) {
				getListView().setItemChecked(index, true);
				DetailFragment detailView = (DetailFragment) getFragmentManager()
						.findFragmentById(R.id.detailView);
				if (detailView == null || detailView.getShownIndex() != index) {
					detailView = DetailFragment.newInstance(index);
					FragmentTransaction ft = getFragmentManager()
							.beginTransaction();
					ft.replace(R.id.detailView, detailView);
					ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_FADE);
					ft.commit();
				}

			} else {
				Intent intent = new Intent();
				intent.setClass(getActivity(), DetailActivity.class);
				intent.putExtra("idx", index);
				startActivity(intent);
			}
		}
	}

	public static class DetailFragment extends Fragment {

		public static DetailFragment newInstance(int index) {
			DetailFragment f = new DetailFragment();
			Bundle args = new Bundle();
			args.putInt("idx", index);
			f.setArguments(args);
			return f;
		}

		public int getShownIndex() {
			return getArguments().getInt("idx", 0);
		}

		private int[] photoa = { R.drawable.image034, R.drawable.image035,
				R.drawable.image037 };

		@Override
		public View onCreateView(LayoutInflater inflater, ViewGroup container,
				Bundle savedInstanceState) {
			if (container == null) {
				return null;
			}

			ScrollView scroller = new ScrollView(getActivity());

			LinearLayout linear = new LinearLayout(getActivity());
			scroller.addView(linear);
			linear.setOrientation(LinearLayout.VERTICAL);

			TextView text = new TextView(getActivity());
			linear.addView(text);
			text.setTextAppearance(getActivity(),
					android.R.style.TextAppearance_Medium);
			String[] detaila = getActivity().getResources().getStringArray(
					R.array.detail);
			text.setText(detaila[getShownIndex()]);

			ImageView img = new ImageView(getActivity());
			linear.addView(img);
			img.setImageDrawable(getActivity().getResources().getDrawable(
					photoa[getShownIndex()]));

			return scroller;
		}
	}
}