package com.owl.sample;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.method.ScrollingMovementMethod;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

public class DialogsActivity extends Activity {
    
	Activity act = this;
	
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        initButton();
    }
    
    public void initButton () {
		((Button) findViewById(R.id.buttonInfo))
    	.setOnClickListener(new OnClickListener() {
            public void onClick(View v) {
            	AlertDialog dialog = new AlertDialog.Builder(act).create();
        		dialog.setTitle("World Popular Famous Foods");
        		dialog.setMessage("한권으로 맛보는 세계의 인기 대표음식들\n\n35개국 음식들을 담고 있습니다.");
        		dialog.setIcon(R.drawable.dishicon_57);
        		dialog.setButton("확인", new DialogInterface.OnClickListener() {
        			public void onClick(DialogInterface dialog, int which) {
        				return;
        			}
        		});
        		dialog.show();
            }
        });
		
    	for (int i=1;i<100;i++) {
    		final int thei = i;
    		int resId = getResources().getIdentifier("button" + i, "id", getPackageName());
    		if (resId <= 0) break;
	    	((Button) findViewById(resId))
	    	.setOnClickListener(new OnClickListener() {
	            public void onClick(View v) {
	                showDialog(thei);
	                if (thei==DIALOG_PROGRESS) {
	                	pCurrent = 0;
	                	pd.setProgress(0);
	                	pHandler.sendEmptyMessage(0);
	                }
	            }
	        });
    	}
    }
    
    private static final int DIALOG_BAGIC = 1;
    private static final int DIALOG_CONFIRM = 2;
    private static final int DIALOG_MULTIBTN = 3;
    private static final int DIALOG_LIST = 4;
    private static final int DIALOG_PROGRESS = 5;
    private static final int DIALOG_SINGLE_CHOICE = 6;
    private static final int DIALOG_MULTI_CHOICE = 7;
    private static final int DIALOG_VIEW = 8;
    
    
    ProgressDialog pd;
    private int pCurrent = 0;
    private Handler pHandler;

    @Override
    protected Dialog onCreateDialog(int id) {
        switch (id) {
        case DIALOG_BAGIC:
        	return new AlertDialog.Builder(act)
        	.setTitle("안내")
        	.setMessage("기본형 대화상자 입니다.")
        	.setPositiveButton("확인", new DialogInterface.OnClickListener() {
        		@Override
				public void onClick(DialogInterface dialog, int which) {
					return;
				}
            })
            .create();

        case DIALOG_CONFIRM:
        	AlertDialog adg = new AlertDialog.Builder(act)
                .setTitle("확인")
                .setMessage("계속 진행할 것인지 선택하는 대화상자입니다.")
                .setPositiveButton("예", new DialogInterface.OnClickListener() {
					public void onClick(DialogInterface dialog, int which) {
						dialog.dismiss();
					}
                })
                .setNegativeButton("아니오", new DialogInterface.OnClickListener() {
					public void onClick(DialogInterface dialog, int which) {
						dialog.dismiss();
					}
                })
                .create();
            return adg;
            
        case DIALOG_MULTIBTN:
        	AlertDialog.Builder adgb = new AlertDialog.Builder(act);
        	adgb.setTitle("확인")
                .setMessage("3개이상의 버튼을 지원합니다.")
                .setPositiveButton("예", new DialogInterface.OnClickListener() {
					public void onClick(DialogInterface dialog, int which) {
						dialog.dismiss();
					}
                })
                .setNegativeButton("아니오", new DialogInterface.OnClickListener() {
					public void onClick(DialogInterface dialog, int which) {
						dialog.dismiss();
					}
                })
                .setNeutralButton("도움말", new DialogInterface.OnClickListener() {
					public void onClick(DialogInterface dialog, int which) {
						dialog.dismiss();
					}
                });
        	return adgb.create();
            
        case DIALOG_LIST:
        	return new AlertDialog.Builder(act)
                .setTitle("목록")
                .setItems(R.array.dialog_items, new DialogInterface.OnClickListener() {
					public void onClick(DialogInterface dialog, int which) {
						String[] items = getResources().getStringArray(R.array.dialog_items);
                       Toast.makeText(act, "\"" + which + "번 " + items[which] + "\"을 선택했습니다.", 
                    		   Toast.LENGTH_SHORT).show();
					}
                })
                .create();
            
        case DIALOG_PROGRESS:
        	//ProgressDialog pd;
        	pd = new ProgressDialog(act);
        	pd.setTitle("진행대화상자");
        	pd.setProgressStyle(ProgressDialog.STYLE_HORIZONTAL);
        	pd.setMax(100);
        	pd.setButton(DialogInterface.BUTTON_POSITIVE, "닫기"
        			, new DialogInterface.OnClickListener() {
				public void onClick(DialogInterface dialog, int which) {
//					dialog.dismiss();
				}
            });
        	pd.setButton(DialogInterface.BUTTON_NEGATIVE, "취소"
        			, new DialogInterface.OnClickListener() {
        		public void onClick(DialogInterface dialog, int which) {
//        			dialog.dismiss();
				}
            });

            pHandler = new Handler() {
                @Override
                public void handleMessage(Message msg) {
                    super.handleMessage(msg);
                    if (pCurrent >= 100) {
                        pd.dismiss();
                    } else {
                    	pCurrent++;
                    	pd.incrementProgressBy(1);
                    	pHandler.sendEmptyMessageDelayed(0, 100);
                    }
                }
            };

            return pd;
            
        case DIALOG_SINGLE_CHOICE:
        	return new AlertDialog.Builder(act)
        		.setTitle("다음중 하나를 선택하세요.")
                .setSingleChoiceItems(R.array.dialog_items, 0
                		, new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int whichButton) {

                    }
                })
                .setPositiveButton("확인", new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int whichButton) {
                    	dialog.dismiss();
                    }
                })
                .setNegativeButton("취소", new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int whichButton) {
                    	dialog.dismiss();
                    }
                })
                .create();
        	
        case DIALOG_MULTI_CHOICE:
            return new AlertDialog.Builder(act)
                .setTitle("선호하는 아이템을 모두 선태하세요.")
                .setMultiChoiceItems(R.array.dialog_items,
                        null,
                        new DialogInterface.OnMultiChoiceClickListener() {
                            public void onClick(DialogInterface dialog, int whichButton,
                                    boolean isChecked) {

                            }
                        })
                .setPositiveButton("확인",
                        new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int whichButton) {
                    	dialog.dismiss();
                    }
                })
                .setNegativeButton("취소",
                        new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int whichButton) {
                    	dialog.dismiss();
                    }
                })
               .create();
            
	    case DIALOG_VIEW:
			final Dialog dialog = new Dialog(act);
			dialog.setContentView(R.layout.notice_detail);
			dialog.setTitle("하즈 비즈 지츠, 오픈 샌드위치 Hobz biz-Zejt");
			TextView noticeDetailContent = (TextView) dialog
					.findViewById(R.id.noticeDetailContent);
			noticeDetailContent.setMovementMethod(new ScrollingMovementMethod());
			((TextView) dialog.findViewById(R.id.noticeDailtOKBtn))
			.setOnClickListener(new OnClickListener() {
	            public void onClick(View v) {
	            	dialog.dismiss();
	            }
	        });
			return dialog;
        }

        return null;
    }
    
}