package com.owl.sample;

import android.app.Activity;
import android.os.Bundle;
import android.widget.DatePicker;
import android.widget.TextView;

public class DatePickerActivity extends Activity {
	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		DatePicker dp = (DatePicker) findViewById(R.id.datePicker1);
		final TextView tv = (TextView) findViewById(R.id.textView2);

		dp.init(dp.getYear(), dp.getMonth(), dp.getDayOfMonth(),
				new DatePicker.OnDateChangedListener() {
					public void onDateChanged(DatePicker view, int year,
							int monthOfYear, int dayOfMonth) {
						tv.setText(String.format("%d년 %d월 %d일", year,
								monthOfYear, dayOfMonth));
					}
				});
	}
}