package com.owl.sample;

import java.util.ArrayList;

import android.app.Activity;
import android.content.ContentUris;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.PixelFormat;
import android.net.Uri;
import android.os.Bundle;
import android.provider.MediaStore;
import android.provider.MediaStore.Images;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.AdapterView.OnItemSelectedListener;

public class GalleryActivity extends Activity {

	Activity act = this;
	OnebyoneGallery gallery;
	// Gallery gallery;
	Uri uriSelected;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		getWindow().setFormat(PixelFormat.TRANSLUCENT);
		requestWindowFeature(Window.FEATURE_NO_TITLE);
		getWindow().addFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN);
		super.onCreate(savedInstanceState);
		setContentView(R.layout.gallery);
		gallery = (OnebyoneGallery) findViewById(R.id.gallery1);
		// gallery = (Gallery) findViewById(R.id.gallery1);
		gallery.setSpacing(30);
		gallery.setUnselectedAlpha(0.30f);
		gallery.setAdapter(new galleryAdapter(this));
		gallery.setOnItemClickListener(new OnItemClickListener() {
			public void onItemClick(AdapterView<?> parent, View v, int position, long id) {
				Intent intent = act.getIntent();
				intent.putExtra("path", uriSelected.toString());
				act.setResult(RESULT_OK, intent);
				finish();
			}
		});
		gallery.setOnItemSelectedListener(new OnItemSelectedListener() {
			@Override
			public void onItemSelected(AdapterView<?> arg0, View arg1, int position, long arg3) {
				if (arg1 != null) {
					uriSelected = galleryOrga.get(position);
				}
			}
			@Override
			public void onNothingSelected(AdapterView<?> arg0) {}
		});
	}

	ArrayList<Uri> gallerya = new ArrayList<Uri>();
	ArrayList<Uri> galleryOrga = new ArrayList<Uri>();

	public class galleryAdapter extends BaseAdapter {
		
		private final Context mContext;
		LayoutInflater inflater;
		int listCount = 0;
		int listCountOrg = 0;
		
		public galleryAdapter(Context c) {
			
			mContext = c;
			inflater = (LayoutInflater) mContext.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
			
			//Thumbnail Uri
			Cursor cursor = mContext.getContentResolver().query(
					MediaStore.Images.Thumbnails.EXTERNAL_CONTENT_URI, null, null, null, null);
			cursor.moveToFirst();
			listCount = cursor.getCount();
			int fdid = cursor
					.getColumnIndexOrThrow(MediaStore.Images.ImageColumns._ID);
			for (int i = 0; i < listCount; i++) {
				long id = cursor.getLong(fdid);
				Uri uri = ContentUris.withAppendedId(
						MediaStore.Images.Thumbnails.EXTERNAL_CONTENT_URI, id);
				gallerya.add(uri);
				cursor.moveToNext();
			}
			cursor.close();

			//Original Uri
			Cursor cursorOrg = mContext.getContentResolver().query(
					Images.Media.EXTERNAL_CONTENT_URI, null, null, null, null);
			cursorOrg.moveToFirst();
			int fdidOrg = cursor.getColumnIndexOrThrow(Images.Media._ID);
			listCountOrg = cursorOrg.getCount();
			for (int i = 0; i < listCountOrg; i++) {
				long id = cursorOrg.getLong(fdidOrg);
				Uri uri = ContentUris.withAppendedId(
						Images.Media.EXTERNAL_CONTENT_URI, id);
				galleryOrga.add(uri);
				cursorOrg.moveToNext();
			}
			cursorOrg.close();
		}

		public int getCount() {
			return gallerya.size();
		}

		public Object getItem(int position) {
			return position;
		}

		public long getItemId(int position) {
			return position;
		}

		public View getView(int position, View convertView, ViewGroup parent) {
			if (convertView == null) {
				convertView = inflater.inflate(R.layout.gallery_item, parent,
						false);
			}

			ImageView imageView = (ImageView) convertView
					.findViewById(R.id.imageView1);
			Uri uri = gallerya.get(position);
			imageView.setImageURI(uri);
			return convertView;
		}
	}

}