package com.owl.sample;

import android.app.Activity;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Intent;
import android.os.Bundle;
import android.os.SystemClock;
import android.view.View;
import android.widget.Chronometer;
import android.widget.Toast;

public class BroadcastReceiverActivity extends Activity {
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
    }
    
    public void vibrateNow(View view) {
		Intent intent = new Intent(this, theBroadcastReceiver.class);
		this.sendBroadcast(intent);
	}
    
    
    public void vibrateTimer(View view) {
		Intent intent = new Intent(this, theBroadcastReceiver.class);
		PendingIntent pendingIntent = PendingIntent.getBroadcast(
				this.getApplicationContext(), 1, intent, 0);
		
		AlarmManager alarmManager = (AlarmManager) getSystemService(ALARM_SERVICE);
		
		final int remainSec = 10;
		long blastTime = System.currentTimeMillis() + (remainSec * 1000);
		
		alarmManager.set(AlarmManager.RTC_WAKEUP, blastTime, pendingIntent);
		
		final Chronometer ct;
		ct = (Chronometer) findViewById(R.id.chronometer1);
		ct.setBase(SystemClock.elapsedRealtime());
		ct.start();
	    ct.setOnChronometerTickListener(new Chronometer.OnChronometerTickListener() {
	        @Override
	        public void onChronometerTick(Chronometer chronometer) {
	        	long elapsedMillis = SystemClock.elapsedRealtime() - ct.getBase(); 
	        	if (elapsedMillis >= remainSec * 1000) {
	        		ct.stop();
	        	}
	        }
	    });
	    
		String msg = "도망가세요!!\n\n" + remainSec + "초후에 터집니다.";
		Toast.makeText(this, msg, Toast.LENGTH_LONG).show();
	}

}