package com.owl.sample;

import java.util.ArrayList;
import java.util.List;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterViewFlipper;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ToggleButton;

public class AdapterViewFlipperActivity extends Activity {

	List<Integer> galleryIda = new ArrayList<Integer>();
	AdapterViewFlipper avf;
	ToggleButton tb;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
		for (int i = 1; i < 10; i++) {
			galleryIda.add(getResources().getIdentifier("p" + i, "drawable",
					this.getPackageName()));
		}

		avf = (AdapterViewFlipper) findViewById(R.id.adapterViewFlipper1);
		avf.setAdapter(new galleryAdapter(this));

		((Button) findViewById(R.id.button1))
				.setOnClickListener(new View.OnClickListener() {
					public void onClick(View view) {
						avf.showPrevious();
					}
				});
		((Button) findViewById(R.id.button2))
				.setOnClickListener(new View.OnClickListener() {
					public void onClick(View view) {
						avf.showNext();
					}
				});

		tb = (ToggleButton) findViewById(R.id.toggleButton1);
		tb.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				avf.stopFlipping();
				if (tb.isChecked()) {
					avf.startFlipping();
				} else {
					avf.stopFlipping();
				}
			}
		});
	}

	@Override
	protected void onResume() {
		super.onResume();
		Log.v("onResume", ":" + tb.isChecked());
		// avf.setAutoStart(true);
		if (tb.isChecked()) {
			avf.startFlipping();
		} else {
			avf.stopFlipping();
		}
	}

	public class galleryAdapter extends BaseAdapter {

		private final Context mContext;
		LayoutInflater inflater;

		public galleryAdapter(Context c) {
			mContext = c;
			inflater = (LayoutInflater) mContext
					.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		}

		public int getCount() {
			return galleryIda.size();
		}

		public Object getItem(int position) {
			return position;
		}

		public long getItemId(int position) {
			return position;
		}

		public View getView(int position, View convertView, ViewGroup parent) {
			if (convertView == null) {
				convertView = inflater.inflate(R.layout.item, parent, false);
			}
			ImageView imageView = (ImageView) convertView
					.findViewById(R.id.imageView1);
			imageView.setImageResource(galleryIda.get(position));
			return convertView;
		}
	}
}