package com.owl.sample;

import java.util.ArrayList;
import java.util.List;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.StackView;

public class StackViewActivity extends Activity {
	List<Integer> galleryIda = new ArrayList<Integer>();
	StackView sv;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		for (int i = 1; i < 9; i++) {
			galleryIda.add(getResources().getIdentifier("p" + i, "drawable",
					this.getPackageName()));
		}

		sv = (StackView) findViewById(R.id.stackView1);
		sv.setAdapter(new galleryAdapter(this));

		((Button) findViewById(R.id.button1))
				.setOnClickListener(new View.OnClickListener() {
					public void onClick(View view) {
						sv.showPrevious();
					}
				});
		((Button) findViewById(R.id.button2))
				.setOnClickListener(new View.OnClickListener() {
					public void onClick(View view) {
						sv.showNext();
					}
				});

	}

	public class galleryAdapter extends BaseAdapter {

		private final Context mContext;
		LayoutInflater inflater;

		public galleryAdapter(Context c) {
			mContext = c;
			inflater = (LayoutInflater) mContext
					.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		}

		public int getCount() {
			return galleryIda.size();
		}

		public Object getItem(int position) {
			return position;
		}

		public long getItemId(int position) {
			return position;
		}

		public View getView(int position, View convertView, ViewGroup parent) {
			if (convertView == null) {
				convertView = inflater.inflate(R.layout.item, parent, false);
			}
			ImageView imageView = (ImageView) convertView
					.findViewById(R.id.imageView1);
			imageView.setImageResource(galleryIda.get(position));
			return convertView;
		}
	}
}