package com.owl.sample;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.view.View;
import android.widget.Button;

public class ServiceActivity extends Activity {
    
	Activity act = this;
	
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);

		findViewById(R.id.button1).setOnClickListener(new Button.OnClickListener() {
			public void onClick(View v) {
				requestLuckNum(v);
			}
		});
    }
    
    @Override
    protected void onStart() {
        super.onStart();
        bindService(new Intent(this, MSGService.class), serviceCon,
            Context.BIND_AUTO_CREATE);
    }

    @Override
    protected void onStop() {
        super.onStop();
        if (boundStat) {
            unbindService(serviceCon);
            boundStat = false;
        }
    }
    
    
    Messenger msgr = null;
    boolean boundStat;

    private ServiceConnection serviceCon = new ServiceConnection() {
        public void onServiceConnected(ComponentName className, IBinder service) {
            msgr = new Messenger(service);
            boundStat = true;
        }

        public void onServiceDisconnected(ComponentName className) {
            msgr = null;
            boundStat = false;
        }
    };

    public void requestLuckNum(View v) {
        if (!boundStat) return;
        Message msg = Message.obtain(null, MSGService.MSG_WHAT_RANDOM, 0, 0);
        try {
            msgr.send(msg);
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }
}