package com.owl.sample;

import android.app.Activity;
import android.os.Bundle;
import android.view.WindowManager;
import android.widget.SeekBar;
import android.widget.TextView;

public class SeekBarActivity extends Activity {
	private SeekBar sb;
	private int brightness = 50;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		sb = (SeekBar) findViewById(R.id.seekBar1);
		sb.setProgress(brightness);
		sb.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
			public void onProgressChanged(SeekBar seekBar, int progress,
					boolean fromUser) {
				printSelected(progress);
			}

			public void onStartTrackingTouch(SeekBar seekBar) {
			}

			public void onStopTrackingTouch(SeekBar seekBar) {
				doAfterTrack();
			}
		});
	}

	public void printSelected(int value) {
		TextView tv = (TextView) findViewById(R.id.textView2);
		tv.setText(String.valueOf(value));
		setBrightness(value);
	}

	private void setBrightness(int value) {
		if (value < 10) {
			value = 10;
		} else if (value > 100) {
			value = 100;
		}
		brightness = value;
		WindowManager.LayoutParams lp = getWindow().getAttributes();
		lp.alpha = (float) value / 100;
		lp.flags |= WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON;
		getWindow().setAttributes(lp);
	}

	private void doAfterTrack() {
		TextView tv = (TextView) findViewById(R.id.textView2);
		tv.setText("Seeked Value : " + tv.getText());
	}
}
