package com.owl.sample;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

public class listAdapter extends BaseAdapter {

	LayoutInflater inflater;
	String[] categorya;
	Context mContext;
	int mListLayout;
	public String TAG = "listAdapter";
	public int listCount = 0;

	public listAdapter(Context tContext, int listLayout, String[] tmpa) {
		mContext = tContext;
		mListLayout = listLayout;
		categorya = tmpa;
		inflater = (LayoutInflater) mContext
				.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		if (categorya != null) {
			listCount = categorya.length;
		}
	}

	@Override
	public int getCount() {
		// TODO Auto-generated method stub
		return listCount;
	}

	@Override
	public Object getItem(int arg0) {
		// TODO Auto-generated method stub
		return arg0;
	}

	@Override
	public long getItemId(int position) {
		// TODO Auto-generated method stub
		return position;
	}

	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
		// TODO Auto-generated method stub
		if (convertView == null) {
			convertView = inflater.inflate(mListLayout, parent, false);
		}

		final int positionInt = position;

		((TextView) convertView.findViewById(R.id.textView1))
				.setText(categorya[position]);

		convertView.setOnClickListener(new Button.OnClickListener() {
			public void onClick(View v) {
				detailInfo(positionInt);
			}
		});

		return convertView;
	}

	public void detailInfo(int position) {

		AlertDialog.Builder detailPop = new AlertDialog.Builder(mContext);
		detailPop.setMessage(categorya[position]).setCancelable(false)
				.setPositiveButton("확인", new DialogInterface.OnClickListener() {
					public void onClick(DialogInterface dialog, int id) {
						Toast.makeText(mContext, "확인을 선택했습니다.",
								Toast.LENGTH_LONG).show();
					}
				}).setNegativeButton("닫기",
						new DialogInterface.OnClickListener() {
							public void onClick(DialogInterface dialog, int id) {
								dialog.cancel();
							}
						});
		AlertDialog alert = detailPop.create();
		alert.setTitle("상세정보");
		alert.setIcon(android.R.drawable.ic_search_category_default);
		alert.show();
	}

}
