package com.owl.sample;

import android.app.Activity;
import android.graphics.drawable.AnimationDrawable;
import android.os.Bundle;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.LayoutAnimationController;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;

public class AnimationActivity extends Activity {

	Activity act = this;
	ImageView targetImg;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
		
		targetImg = (ImageView) findViewById(R.id.imageView1);
		initButtons();
		
		LayoutAnimationController controller = AnimationUtils
		.loadLayoutAnimation(act, R.anim.layout_anim);
		LinearLayout ll = (LinearLayout) findViewById(R.id.linearLayout1);
		ll.setLayoutAnimation(controller);
		ll.startLayoutAnimation();
	}

	public void initButtons() {
		findViewById(R.id.button1).setOnClickListener(
				new Button.OnClickListener() {
					public void onClick(View v) {
						Animation anim = AnimationUtils.loadAnimation(act,
								R.anim.alpha);
						targetImg.startAnimation(anim);
					}
				});

		findViewById(R.id.button2).setOnClickListener(
				new Button.OnClickListener() {
					public void onClick(View v) {
						Animation anim = AnimationUtils.loadAnimation(act,
								R.anim.rotate);
						targetImg.startAnimation(anim);
					}
				});

		findViewById(R.id.button3).setOnClickListener(
				new Button.OnClickListener() {
					public void onClick(View v) {
						Animation anim = AnimationUtils.loadAnimation(act,
								R.anim.scale);
						targetImg.startAnimation(anim);
					}
				});

		findViewById(R.id.button4).setOnClickListener(
				new Button.OnClickListener() {
					public void onClick(View v) {
						Animation anim = AnimationUtils.loadAnimation(act,
								R.anim.translate);
						targetImg.startAnimation(anim);
					}
				});

		findViewById(R.id.button5).setOnClickListener(
				new Button.OnClickListener() {
					public void onClick(View v) {
						Animation anim = AnimationUtils.loadAnimation(act,
								R.anim.tween);
						targetImg.startAnimation(anim);
					}
				});

		findViewById(R.id.button6).setOnClickListener(
				new Button.OnClickListener() {
					public void onClick(View v) {
						ImageView img = (ImageView) findViewById(R.id.imageView2);
						img.setBackgroundResource(R.drawable.anim_sound);
						AnimationDrawable equalAnim = (AnimationDrawable) img.getBackground();
						if (equalAnim.isRunning()) {
							img.setBackgroundResource(0);
							equalAnim.stop();
						} else {
							equalAnim.start();
						}
					}
				});

	}
}